/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.ArrayList;
import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class MopacGraphfReader
extends MopacSlaterReader {
    private int atomCount;
    private int nCoefficients;
    private float[][] invMatrix;
    private boolean isNewFormat;
    private ArrayList orbitalData;
    private ArrayList orbitalInfo;

    protected void initializeReader() {
        this.alphaBeta = "alpha";
    }

    protected boolean checkLine() throws Exception {
        this.readAtoms();
        if (this.readMolecularOrbitals) {
            this.readSlaterBasis();
            this.readMolecularOrbitals(false);
            if (this.readKeywords()) {
                this.readMolecularOrbitals(true);
            }
        }
        this.continuing = false;
        return false;
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomCount = this.parseInt(this.line);
        this.atomicNumbers = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            this.atomicNumbers[i] = this.parseInt(this.line.substring(0, 4));
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.x = this.parseFloat(this.line.substring(4, 17));
            atom.y = this.parseFloat(this.line.substring(17, 29));
            atom.z = this.parseFloat(this.line.substring(29, 41));
            if (this.line.length() > 41) {
                atom.partialCharge = this.parseFloat(this.line.substring(41));
            }
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(this.atomicNumbers[i]);
        }
    }

    private void readSlaterBasis() throws Exception {
        this.nCoefficients = 0;
        float[] fArray = new float[3];
        for (int i = 0; i < this.atomCount; ++i) {
            MopacGraphfReader.getTokensFloat(this.readLine(), fArray, 3);
            int n = this.atomicNumbers[i];
            float f = fArray[0];
            if (f != 0.0f) {
                this.createSphericalSlaterByType(i, n, "S", f, 1.0f);
            }
            if ((f = fArray[1]) != 0.0f) {
                this.createSphericalSlaterByType(i, n, "Px", f, 1.0f);
                this.createSphericalSlaterByType(i, n, "Py", f, 1.0f);
                this.createSphericalSlaterByType(i, n, "Pz", f, 1.0f);
            }
            if ((f = fArray[2]) == 0.0f) continue;
            this.createSphericalSlaterByType(i, n, "Dx2-y2", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dxz", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dz2", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dyz", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dxy", f, 1.0f);
        }
        this.nCoefficients = this.slaters.size();
        this.setSlaters(true, false);
    }

    private void readMolecularOrbitals(boolean bl) throws Exception {
        int n;
        int n2;
        if (bl) {
            this.alphaBeta = "beta";
        }
        Object object = null;
        if (this.readLine() == null) {
            return;
        }
        boolean bl2 = this.isNewFormat = this.line.indexOf("ORBITAL") >= 0;
        if (this.isNewFormat) {
            this.orbitalData = new ArrayList();
            if (this.line.length() > 10) {
                this.orbitalInfo = new ArrayList();
            }
        } else {
            object = new float[this.nCoefficients][this.nCoefficients];
        }
        for (n2 = 0; n2 < this.nCoefficients; ++n2) {
            float[] fArray;
            if (n2 != 0) {
                this.readLine();
            }
            if (this.isNewFormat) {
                if (this.line == null || this.line.indexOf("ORBITAL") < 0 || this.line.indexOf("ORBITAL_LIST") >= 0) break;
                fArray = new float[this.nCoefficients];
                this.orbitalData.add(fArray);
                if (this.orbitalInfo != null) {
                    this.orbitalInfo.add(this.line);
                }
                this.readLine();
            } else {
                fArray = object[n2];
            }
            this.fillFloatArray(fArray, this.line, 15);
        }
        if (this.invMatrix == null) {
            if (this.isNewFormat && this.line.indexOf("MATRIX") < 0) {
                this.readLine();
            }
            this.invMatrix = new float[this.nCoefficients][];
            for (n2 = 0; n2 < this.nCoefficients; ++n2) {
                this.invMatrix[n2] = new float[n2 + 1];
                this.fillFloatArray(this.invMatrix[n2], null, 15);
            }
        }
        int n3 = this.nOrbitals = this.orbitalData == null ? this.nCoefficients : this.orbitalData.size();
        if (this.orbitalData != null) {
            object = new float[this.nOrbitals][];
            n2 = this.nOrbitals;
            while (--n2 >= 0) {
                object[n2] = (float[])this.orbitalData.get(n2);
            }
        }
        float[][] fArray = new float[this.nOrbitals][this.nCoefficients];
        for (int i = 0; i < this.nOrbitals; ++i) {
            for (n = 0; n < this.nCoefficients; ++n) {
                for (int j = 0; j < this.nCoefficients; ++j) {
                    float[] fArray2 = fArray[i];
                    int n4 = n;
                    fArray2[n4] = fArray2[n4] + object[i][j] * (j >= n ? this.invMatrix[j][n] : this.invMatrix[n][j]);
                }
                if (!(Math.abs(fArray[i][n]) < 1.0E-4f)) continue;
                fArray[i][n] = 0.0f;
            }
        }
        if (this.isNewFormat && this.orbitalInfo == null && this.line != null && this.line.indexOf("ORBITAL_LIST") < 0) {
            this.readLine();
        }
        float[] fArray3 = new float[2];
        for (n = 0; n < this.nOrbitals; ++n) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            if (this.orbitalInfo != null) {
                this.line = (String)this.orbitalInfo.get(n);
                String[] stringArray = this.getTokens();
                hashtable.put("energy", new Float(this.parseFloat(stringArray[3])));
                hashtable.put("occupancy", new Float(this.parseFloat(stringArray[1])));
            } else if (this.readLine() != null) {
                MopacGraphfReader.getTokensFloat(this.line, fArray3, 2);
                hashtable.put("energy", new Float(fArray3[0]));
                hashtable.put("occupancy", new Float(fArray3[1]));
            }
            hashtable.put("coefficients", fArray[n]);
            if (bl) {
                hashtable.put("type", "beta");
            }
            this.line = "\n";
            if (!this.filterMO()) continue;
            this.setMO(hashtable);
        }
        this.setMOs("eV");
    }

    private boolean readKeywords() throws Exception {
        boolean bl;
        if (this.readLine() == null || this.line.indexOf(" Keywords:") < 0) {
            return false;
        }
        this.calculationType = this.line.substring(11).trim();
        this.moData.put("calculationType", this.calculationType);
        boolean bl2 = bl = this.line.indexOf("UHF") >= 0;
        if (bl) {
            int n = this.orbitals.size();
            while (--n >= 0) {
                ((Hashtable)this.orbitals.get(n)).put("type", "alpha");
            }
        }
        return bl;
    }
}

