/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolViewer;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;

public abstract class AtomSetCollectionReader {
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    protected AtomSetCollection atomSetCollection;
    protected BufferedReader reader;
    protected String readerName;
    public Hashtable htParams;
    public String line;
    public String prevline;
    protected int[] next = new int[1];
    protected long ptLine;
    public int[] latticeCells;
    public boolean doProcessLines;
    public boolean iHaveUnitCell;
    public boolean iHaveSymmetryOperators;
    protected boolean doApplySymmetry;
    protected boolean ignoreFileSymmetryOperators;
    protected boolean isTrajectory;
    protected boolean applySymmetryToBonds;
    protected boolean doCheckUnitCell;
    protected boolean getHeader;
    protected boolean isSequential;
    protected int templateAtomCount;
    public int modelNumber;
    protected int vibrationNumber;
    public int desiredVibrationNumber = Integer.MIN_VALUE;
    protected BitSet bsModels;
    protected String spaceGroup;
    protected boolean havePartialChargeFilter;
    public String calculationType = "?";
    private boolean iHaveFractionalCoordinates;
    private boolean doPackUnitCell;
    private boolean doConvertToFractional;
    private boolean merging;
    private boolean fileCoordinatesAreFractional;
    protected boolean ignoreFileUnitCell;
    protected boolean ignoreFileSpaceGroupName;
    private float symmetryRange;
    protected float[] notionalUnitCell;
    private int[] firstLastStep;
    protected int desiredModelNumber = Integer.MIN_VALUE;
    private int lastModelNumber = Integer.MAX_VALUE;
    private int desiredSpaceGroupIndex = -1;
    protected SymmetryInterface symmetry;
    protected OutputStream os;
    private Point3f fileScaling;
    private Point3f fileOffset;
    String fileName;
    public boolean continuing = true;
    protected JmolViewer viewer;
    public boolean haveModel;
    private String previousSpaceGroup;
    private float[] previousUnitCell;
    private int nMatrixElements = 0;
    protected Matrix3f matUnitCellOrientation;
    protected BitSet bsFilter;
    protected String filter;
    private boolean haveAtomFilter;
    private boolean filterAltLoc;
    private boolean filterGroup3;
    private boolean filterChain;
    private boolean filterAtomType;
    private boolean doSetOrientation;
    protected boolean addVibrations;
    public boolean readMolecularOrbitals;
    private Matrix3f matrixRotate;
    private Point3f unitCellOffset;
    private String previousScript;
    private String siteScript;

    void setup(String string, Hashtable hashtable, BufferedReader bufferedReader) {
        this.htParams = hashtable;
        this.fileName = string;
        this.reader = bufferedReader;
    }

    Object readData() throws Exception {
        this.initialize();
        this.atomSetCollection = new AtomSetCollection(this.readerName, this);
        try {
            this.initializeReader();
            if (this.line == null && this.continuing) {
                this.readLine();
            }
            while (this.line != null && this.continuing) {
                if (!this.checkLine()) continue;
                this.readLine();
            }
            this.finalizeReader();
        }
        catch (Throwable throwable) {
            this.setError(throwable);
        }
        this.reader.close();
        return this.finish();
    }

    protected Object readData(Object object) {
        this.initialize();
        this.readAtomSetCollectionFromDOM(object);
        return this.finish();
    }

    public void readAtomSetCollectionFromDOM(Object object) {
    }

    protected void initializeReader() throws Exception {
    }

    protected boolean checkLine() throws Exception {
        return true;
    }

    public boolean checkLastModel() {
        if (this.isLastModel(this.modelNumber) && this.doProcessLines) {
            this.continuing = false;
            return false;
        }
        this.doProcessLines = false;
        return true;
    }

    public boolean isLastModel(int n) {
        return this.desiredModelNumber > 0 || n >= this.lastModelNumber;
    }

    protected void finalizeReader() throws Exception {
        this.applySymmetryAndSetTrajectory();
    }

    private Object finish() {
        String string;
        String string2;
        String string3 = (String)this.htParams.get("loadState");
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("loadState", string3 == null ? "" : string3);
        string3 = (String)this.htParams.get("smilesString");
        if (string3 != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("smilesString", string3);
        }
        if (!this.htParams.containsKey("templateAtomCount")) {
            this.htParams.put("templateAtomCount", new Integer(this.atomSetCollection.getAtomCount()));
        }
        if (this.htParams.containsKey("bsFilter")) {
            this.htParams.put("filteredAtomCount", new Integer(BitSetUtil.cardinalityOf((BitSet)this.htParams.get("bsFilter"))));
        }
        if (!this.calculationType.equals("?")) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("calculationType", this.calculationType);
        }
        if ((string2 = (string = this.atomSetCollection.getFileTypeName())).indexOf("(") >= 0) {
            string2 = string2.substring(0, string2.indexOf("("));
        }
        int n = this.atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("fileName", this.fileName, n);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("fileType", string2, n);
        }
        this.atomSetCollection.freeze();
        if (this.atomSetCollection.errorMessage != null) {
            return this.atomSetCollection.errorMessage + "\nfor file " + this.fileName + "\ntype " + string;
        }
        if (this.atomSetCollection.getAtomCount() == 0) {
            return "No atoms found\nfor file " + this.fileName + "\ntype " + string;
        }
        return this.atomSetCollection;
    }

    private void setError(Throwable throwable) {
        throwable.printStackTrace();
        this.atomSetCollection.errorMessage = this.line == null ? "Unexpected end of file after line " + --this.ptLine + ":\n" + this.prevline : "Error reading file at line " + this.ptLine + ":\n" + this.line + "\n" + throwable.getMessage();
    }

    private void initialize() {
        Object object;
        this.initializeSymmetry();
        this.viewer = (JmolViewer)this.htParams.get("viewer");
        this.htParams.remove("viewer");
        this.getHeader = this.htParams.containsKey("getHeader");
        this.isSequential = this.htParams.containsKey("isSequential");
        this.readerName = (String)this.htParams.get("readerName");
        if (this.htParams.containsKey("vibrationNumber")) {
            this.desiredVibrationNumber = (Integer)this.htParams.get("vibrationNumber");
        } else if (this.htParams.containsKey("modelNumber")) {
            this.desiredModelNumber = (Integer)this.htParams.get("modelNumber");
        }
        this.applySymmetryToBonds = this.htParams.containsKey("applySymmetryToBonds");
        this.bsFilter = (BitSet)this.htParams.get("bsFilter");
        this.setFilter((String)this.htParams.get("filter"));
        int n = this.htParams.containsKey("ptFile") ? (Integer)this.htParams.get("ptFile") : -1;
        this.isTrajectory = this.htParams.containsKey("isTrajectory");
        if (n > 0 && this.htParams.containsKey("firstLastSteps")) {
            object = ((Vector)this.htParams.get("firstLastSteps")).elementAt(n - 1);
            if (object instanceof BitSet) {
                this.bsModels = (BitSet)object;
            } else {
                this.firstLastStep = (int[])object;
            }
            this.templateAtomCount = (Integer)this.htParams.get("templateAtomCount");
        } else if (this.htParams.containsKey("firstLastStep")) {
            this.firstLastStep = (int[])this.htParams.get("firstLastStep");
        } else if (this.htParams.containsKey("bsModels")) {
            this.isTrajectory = this.htParams.containsKey("isTrajectory");
            this.bsModels = (BitSet)this.htParams.get("bsModels");
        }
        if (this.bsModels != null || this.firstLastStep != null) {
            this.desiredModelNumber = Integer.MIN_VALUE;
        }
        if (this.bsModels == null && this.firstLastStep != null) {
            if (this.firstLastStep[0] < 0) {
                this.firstLastStep[0] = 0;
            }
            if (this.firstLastStep[2] == 0 || this.firstLastStep[1] < this.firstLastStep[0]) {
                this.firstLastStep[1] = -1;
            }
            if (this.firstLastStep[2] < 1) {
                this.firstLastStep[2] = 1;
            }
            this.bsModels = BitSetUtil.setBit(this.firstLastStep[0]);
            if (this.firstLastStep[1] > this.firstLastStep[0]) {
                for (int i = this.firstLastStep[0]; i <= this.firstLastStep[1]; i += this.firstLastStep[2]) {
                    this.bsModels.set(i);
                }
            }
        }
        if (this.bsModels != null && (this.firstLastStep == null || this.firstLastStep[1] != -1)) {
            this.lastModelNumber = this.bsModels.length();
        }
        this.symmetryRange = this.htParams.containsKey("symmetryRange") ? ((Float)this.htParams.get("symmetryRange")).floatValue() : 0.0f;
        this.latticeCells = new int[3];
        if (this.htParams.containsKey("lattice")) {
            object = (Point3f)this.htParams.get("lattice");
            this.latticeCells[0] = (int)((Point3f)object).x;
            this.latticeCells[1] = (int)((Point3f)object).y;
            this.latticeCells[2] = (int)((Point3f)object).z;
            this.doPackUnitCell = this.htParams.containsKey("packed") || this.latticeCells[2] < 0;
        }
        boolean bl = this.doApplySymmetry = this.latticeCells[0] > 0 && this.latticeCells[1] > 0;
        if (!this.doApplySymmetry) {
            this.latticeCells[0] = 0;
            this.latticeCells[1] = 0;
            this.latticeCells[2] = 0;
        }
        if (this.htParams.containsKey("spaceGroupIndex")) {
            this.desiredSpaceGroupIndex = (Integer)this.htParams.get("spaceGroupIndex");
            if (this.desiredSpaceGroupIndex == -2) {
                this.spaceGroup = (String)this.htParams.get("spaceGroupName");
            }
            this.ignoreFileSpaceGroupName = this.desiredSpaceGroupIndex == -2 || this.desiredSpaceGroupIndex >= 0;
            boolean bl2 = this.ignoreFileSymmetryOperators = this.desiredSpaceGroupIndex != -1;
        }
        if (this.htParams.containsKey("unitcell")) {
            object = (float[])this.htParams.get("unitcell");
            this.setUnitCell((float)object[0], (float)object[1], (float)object[2], (float)object[3], (float)object[4], (float)object[5]);
            this.ignoreFileUnitCell = this.iHaveUnitCell;
        }
        this.merging = this.htParams.containsKey("merging");
        if (this.htParams.containsKey("OutputStream")) {
            this.os = (OutputStream)this.htParams.get("OutputStream");
        }
    }

    public boolean doGetModel(int n) {
        boolean bl;
        boolean bl2 = this.bsModels == null ? this.desiredModelNumber < 1 : (n > this.lastModelNumber ? false : (bl = n > 0 && this.bsModels.get(n - 1) || this.haveModel && this.firstLastStep != null && this.firstLastStep[1] < 0 && (this.firstLastStep[2] < 2 || (n - 1 - this.firstLastStep[0]) % this.firstLastStep[2] == 0)));
        if (bl && this.desiredModelNumber == 0) {
            this.atomSetCollection.discardPreviousAtoms();
        }
        System.out.println("doGetModel isOK desired modelNUmber  " + bl + " " + this.desiredModelNumber + " " + n);
        this.haveModel |= bl;
        if (bl) {
            this.doProcessLines = true;
        }
        return bl;
    }

    protected void initializeSymmetry() {
        this.previousSpaceGroup = this.spaceGroup;
        this.previousUnitCell = this.notionalUnitCell;
        this.iHaveUnitCell = this.ignoreFileUnitCell;
        if (!this.ignoreFileUnitCell) {
            this.notionalUnitCell = new float[22];
            int n = 22;
            while (--n >= 0) {
                this.notionalUnitCell[n] = Float.NaN;
            }
            this.symmetry = null;
        }
        if (!this.ignoreFileSpaceGroupName) {
            this.spaceGroup = "unspecified!";
        }
        this.doCheckUnitCell = false;
    }

    protected void newAtomSet(String string) {
        if (this.atomSetCollection.getCurrentAtomSetIndex() >= 0) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setCollectionName("<collection of " + (this.atomSetCollection.getCurrentAtomSetIndex() + 1) + " models>");
        } else {
            this.atomSetCollection.setCollectionName(string);
        }
        Logger.debug(string);
    }

    protected int cloneLastAtomSet(int n) throws Exception {
        this.applySymmetryAndSetTrajectory();
        int n2 = this.atomSetCollection.getLastAtomSetAtomCount();
        this.atomSetCollection.cloneLastAtomSet(n);
        if (this.atomSetCollection.haveUnitCell) {
            this.iHaveUnitCell = true;
            this.doCheckUnitCell = true;
            this.spaceGroup = this.previousSpaceGroup;
            this.notionalUnitCell = this.previousUnitCell;
        }
        return n2;
    }

    public void setSpaceGroupName(String string) {
        if (this.ignoreFileSpaceGroupName) {
            return;
        }
        this.spaceGroup = string.trim();
        Logger.info("Setting space group name to " + this.spaceGroup);
    }

    public void setSymmetryOperator(String string) {
        if (this.ignoreFileSymmetryOperators) {
            return;
        }
        this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds, this.doPackUnitCell);
        if (!this.atomSetCollection.addSpaceGroupOperation(string)) {
            Logger.warn("Skipping symmetry operation " + string);
        }
        this.iHaveSymmetryOperators = true;
    }

    private void initializeCartesianToFractional() {
        int n;
        for (n = 0; n < 16; ++n) {
            if (Float.isNaN(this.notionalUnitCell[6 + n])) continue;
            return;
        }
        for (n = 0; n < 16; ++n) {
            this.notionalUnitCell[6 + n] = n % 5 == 0 ? 1 : 0;
        }
        this.nMatrixElements = 0;
    }

    public void clearLatticeParameters() {
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (int i = 6; i < this.notionalUnitCell.length; ++i) {
            this.notionalUnitCell[i] = Float.NaN;
        }
        this.checkUnitCell(6);
    }

    public void setUnitCellItem(int n, float f) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (n == 0 && f == 1.0f || n == 3 && f == 0.0f) {
            return;
        }
        if (!Float.isNaN(f) && n >= 6 && Float.isNaN(this.notionalUnitCell[6])) {
            this.initializeCartesianToFractional();
        }
        this.notionalUnitCell[n] = f;
        if (Logger.debugging) {
            Logger.debug("setunitcellitem " + n + " " + f);
        }
        if (n < 6 || Float.isNaN(f)) {
            this.iHaveUnitCell = this.checkUnitCell(6);
        } else if (++this.nMatrixElements == 12) {
            this.checkUnitCell(22);
        }
    }

    public void setUnitCell(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        this.notionalUnitCell[0] = f;
        this.notionalUnitCell[1] = f2;
        this.notionalUnitCell[2] = f3;
        if (f4 != 0.0f) {
            this.notionalUnitCell[3] = f4;
        }
        if (f5 != 0.0f) {
            this.notionalUnitCell[4] = f5;
        }
        if (f6 != 0.0f) {
            this.notionalUnitCell[5] = f6;
        }
        this.iHaveUnitCell = this.checkUnitCell(6);
    }

    public void addPrimitiveLatticeVector(int n, float[] fArray) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        n = 6 + n * 3;
        this.notionalUnitCell[n++] = fArray[0];
        this.notionalUnitCell[n++] = fArray[1];
        this.notionalUnitCell[n++] = fArray[2];
        this.iHaveUnitCell = this.checkUnitCell(15);
    }

    private boolean checkUnitCell(int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(this.notionalUnitCell[i])) continue;
            return false;
        }
        this.getSymmetry().setUnitCell(this.notionalUnitCell);
        if (this.doApplySymmetry) {
            this.doConvertToFractional = !this.fileCoordinatesAreFractional;
        }
        return true;
    }

    protected SymmetryInterface getSymmetry() {
        this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        return this.symmetry;
    }

    public void setFractionalCoordinates(boolean bl) {
        this.iHaveFractionalCoordinates = this.fileCoordinatesAreFractional = bl;
    }

    protected void setFilter(String string) {
        if (string != null) {
            string = string.toUpperCase();
        }
        this.filter = string;
        this.doSetOrientation = !this.checkFilter("NOORIENT");
        this.addVibrations = !this.checkFilter("NOVIB");
        boolean bl = this.readMolecularOrbitals = !this.checkFilter("NOMO");
        if (this.filter == null) {
            return;
        }
        this.filterAtomType = this.checkFilter("*.") || this.checkFilter("!.");
        this.filterGroup3 = this.checkFilter("[");
        this.filterChain = this.checkFilter(":");
        this.filterAltLoc = this.checkFilter("%");
        boolean bl2 = this.haveAtomFilter = this.filterAtomType || this.filterGroup3 || this.filterChain || this.filterAltLoc;
        if (this.bsFilter == null) {
            this.bsFilter = new BitSet();
            this.htParams.put("bsFilter", this.bsFilter);
            this.filter = (";" + this.filter + ";").replace(',', ';');
            Logger.info("filtering with " + this.filter);
        }
    }

    public boolean checkFilter(String string) {
        return this.filter != null && this.filter.indexOf(string) >= 0;
    }

    protected boolean filterAtom(Atom atom) {
        return !this.haveAtomFilter || this.filterAtom(atom, -1);
    }

    protected boolean filterAtom(Atom atom, int n) {
        boolean bl = !(this.filterGroup3 && atom.group3 != null && this.filterReject("![", "[" + atom.group3.toUpperCase() + "]") || this.filterAtomType && atom.atomName != null && this.filterReject("!.", "." + atom.atomName.toUpperCase() + ";") || this.filterChain && atom.chainID != '\u0000' && this.filterReject("!:", ":" + atom.chainID) || this.filterAltLoc && atom.alternateLocationID != '\u0000' && this.filterReject("!%", "%" + atom.alternateLocationID));
        this.bsFilter.set(n >= 0 ? n : this.atomSetCollection.getAtomCount(), bl);
        return bl;
    }

    private boolean filterReject(String string, String string2) {
        return this.filter.indexOf(string) >= 0 ? this.filter.indexOf(string2) >= 0 : this.filter.indexOf(string2) < 0;
    }

    protected void set2D() {
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("is2D", Boolean.TRUE);
        if (!this.checkFilter("NOMIN")) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("doMinimize", Boolean.TRUE);
        }
    }

    public boolean doGetVibration(int n) {
        return this.addVibrations && (this.desiredVibrationNumber <= 0 || n == this.desiredVibrationNumber);
    }

    public void setTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.matrixRotate != null || !this.doSetOrientation) {
            return;
        }
        this.matrixRotate = new Matrix3f();
        Vector3f vector3f = new Vector3f();
        vector3f.set(f, f2, f3);
        vector3f.normalize();
        this.matrixRotate.setColumn(0, vector3f);
        vector3f.set(f4, f5, f6);
        vector3f.normalize();
        this.matrixRotate.setColumn(1, vector3f);
        vector3f.set(f7, f8, f9);
        vector3f.normalize();
        this.matrixRotate.setColumn(2, vector3f);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("defaultOrientationMatrix", new Matrix3f(this.matrixRotate));
        Quaternion quaternion = new Quaternion(this.matrixRotate);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("defaultOrientationQuaternion", quaternion);
        Logger.info("defaultOrientationMatrix = " + this.matrixRotate);
    }

    public void setAtomCoord(Atom atom, float f, float f2, float f3) {
        atom.set(f, f2, f3);
        this.setAtomCoord(atom);
    }

    public void setAtomCoord(Atom atom) {
        if (this.fileScaling != null) {
            atom.x = atom.x * this.fileScaling.x + this.fileOffset.x;
            atom.y = atom.y * this.fileScaling.y + this.fileOffset.y;
            atom.z = atom.z * this.fileScaling.z + this.fileOffset.z;
        }
        if (this.doConvertToFractional && !this.fileCoordinatesAreFractional && this.symmetry != null) {
            this.symmetry.toFractional(atom, false);
            this.iHaveFractionalCoordinates = true;
        }
        this.doCheckUnitCell = true;
    }

    protected void addSites(Hashtable hashtable) {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("pdbSites", hashtable);
        Enumeration enumeration = hashtable.keys();
        String string = "";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
            int n = string2.length();
            while (--n >= 0) {
                char c = string2.charAt(n);
                if (Character.isLetterOrDigit(c) || c == '\'') continue;
                string2 = string2.substring(0, n) + "_" + string2.substring(n + 1);
            }
            String string3 = (String)hashtable2.get("groups");
            if (string3.length() == 0) continue;
            this.addSiteScript("@site_" + string2 + " " + string3);
            this.addSiteScript("site_" + string2 + " = \"" + string3 + "\".split(\",\")");
            string = string + (string == "" ? "" : ",") + "site_" + string2;
        }
        this.addSiteScript("site_list = \"" + string + "\".split(\",\")");
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        if (this.iHaveUnitCell && this.doCheckUnitCell) {
            this.atomSetCollection.setCoordinatesAreFractional(this.iHaveFractionalCoordinates);
            this.atomSetCollection.setNotionalUnitCell(this.notionalUnitCell, this.matUnitCellOrientation, this.unitCellOffset);
            this.atomSetCollection.setAtomSetSpaceGroupName(this.spaceGroup);
            this.atomSetCollection.setSymmetryRange(this.symmetryRange);
            if (this.doConvertToFractional || this.fileCoordinatesAreFractional) {
                this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds, this.doPackUnitCell);
                if (this.ignoreFileSpaceGroupName || !this.iHaveSymmetryOperators) {
                    if (this.createSpaceGroup()) {
                        this.atomSetCollection.setAtomSetSpaceGroupName(this.symmetry.getSpaceGroupName());
                        this.atomSetCollection.applySymmetry(this.symmetry);
                    }
                } else {
                    this.atomSetCollection.applySymmetry();
                }
            }
            if (this.iHaveFractionalCoordinates && this.merging && this.symmetry != null) {
                this.atomSetCollection.toCartesian(this.symmetry);
                this.atomSetCollection.setAtomSetAuxiliaryInfo("coordinatesAreFractional", Boolean.FALSE);
                this.addVibrations = false;
            }
        }
        if (this.isTrajectory) {
            this.atomSetCollection.setTrajectory();
        }
        this.initializeSymmetry();
    }

    protected boolean createSpaceGroup() {
        return this.getSymmetry().createSpaceGroup(this.desiredSpaceGroupIndex, this.spaceGroup.indexOf("!") >= 0 ? "P1" : this.spaceGroup, this.notionalUnitCell, this.atomSetCollection.doNormalize);
    }

    public void setMOData(Hashtable hashtable) {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", hashtable);
        Vector vector = (Vector)hashtable.get("mos");
        if (vector != null) {
            Logger.info(vector.size() + " molecular orbitals read in model " + this.atomSetCollection.getAtomSetCount());
        }
    }

    public static String getElementSymbol(int n) {
        return JmolAdapter.getElementSymbol(n);
    }

    protected void fillDataBlock(String[][] stringArray, int n, int n2) throws Exception {
        if (n2 == 0) {
            this.fillDataBlock(stringArray);
            return;
        }
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            this.discardLinesUntilNonBlank();
            int n4 = (this.line.length() - n) / n2;
            stringArray[i] = new String[n4];
            int n5 = 0;
            int n6 = n;
            while (n5 < n4) {
                stringArray[i][n5] = this.line.substring(n6, n6 + n2);
                ++n5;
                n6 += n2;
            }
        }
    }

    protected void fillDataBlock(String[][] stringArray) throws Exception {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = AtomSetCollectionReader.getTokens(this.discardLinesUntilNonBlank());
        }
    }

    protected void fillFloatArray(float[] fArray, String string, int n) throws Exception {
        String[] stringArray = new String[]{};
        int n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            while (stringArray != null && n2 >= stringArray.length) {
                if (string == null) {
                    string = this.readLine();
                }
                if (n == 0) {
                    stringArray = AtomSetCollectionReader.getTokens(string);
                } else {
                    stringArray = new String[string.length() / n];
                    for (int j = 0; j < stringArray.length; ++j) {
                        stringArray[j] = string.substring(j * n, (j + 1) * n);
                    }
                }
                string = null;
                n2 = 0;
            }
            if (stringArray == null) break;
            fArray[i] = this.parseFloat(stringArray[n2++]);
        }
    }

    protected void fillFrequencyData(int n, int n2, int n3, boolean[] blArray, boolean bl, int n4, int n5, int[] nArray) throws Exception {
        boolean bl2;
        boolean bl3 = bl2 = n3 != n2;
        if (nArray != null) {
            n2 = nArray.length;
        }
        int n6 = bl ? n2 : n2 * 3;
        int n7 = blArray.length;
        String[][] stringArray = new String[n6][];
        this.fillDataBlock(stringArray, n4, n5);
        int n8 = 0;
        int n9 = 0;
        while (n8 < n6) {
            String[] stringArray2 = stringArray[n8];
            String[] stringArray3 = bl ? null : stringArray[++n8];
            String[] stringArray4 = bl ? null : stringArray[++n8];
            int n10 = stringArray2.length - (bl ? n7 * 3 : n7) - 1;
            for (int i = 0; i < n7; ++i) {
                int n11;
                String string;
                if ((string = stringArray2[++n10]).charAt(0) == ')') {
                    string = string.substring(1);
                }
                float f = this.parseFloat(string);
                float f2 = this.parseFloat(bl ? stringArray2[++n10] : stringArray3[n10]);
                float f3 = this.parseFloat(bl ? stringArray2[++n10] : stringArray4[n10]);
                if (blArray[i]) continue;
                int n12 = n11 = nArray == null ? n9 : nArray[n9];
                if (n11 < 0) continue;
                if (Logger.debugging) {
                    Logger.debug("vib " + n11 + "/" + i + ": " + f + " " + f2 + " " + f3);
                }
                this.atomSetCollection.addVibrationVector(n + n3 * i + n11, f, f2, f3, bl2);
            }
            ++n8;
            ++n9;
        }
    }

    protected void discardLines(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.readLine();
        }
    }

    protected String discardLinesUntilStartsWith(String string) throws Exception {
        while (this.readLine() != null && !this.line.startsWith(string)) {
        }
        return this.line;
    }

    protected String discardLinesUntilContains(String string) throws Exception {
        while (this.readLine() != null && this.line.indexOf(string) < 0) {
        }
        return this.line;
    }

    protected void discardLinesUntilBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() != 0) {
        }
    }

    protected String discardLinesUntilNonBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() == 0) {
        }
        return this.line;
    }

    protected void checkLineForScript(String string) {
        this.line = string;
        this.checkLineForScript();
    }

    public void checkLineForScript() {
        int n;
        Object object;
        if (this.line.indexOf("Jmol") >= 0) {
            if (this.line.indexOf("Jmol PDB-encoded data") >= 0) {
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolData", this.line);
                if (!this.line.endsWith("#noautobond")) {
                    this.line = this.line + "#noautobond";
                }
            }
            if (this.line.indexOf("Jmol data min") >= 0) {
                Logger.info(this.line);
                float[] fArray = new float[15];
                this.parseStringInfestedFloatArray(this.line.substring(10).replace('=', ' ').replace('{', ' ').replace('}', ' '), fArray);
                object = new Point3f(fArray[0], fArray[1], fArray[2]);
                Point3f point3f = new Point3f(fArray[3], fArray[4], fArray[5]);
                this.fileScaling = new Point3f(fArray[6], fArray[7], fArray[8]);
                this.fileOffset = new Point3f(fArray[9], fArray[10], fArray[11]);
                Point3f point3f2 = new Point3f(fArray[12], fArray[13], fArray[14]);
                if (point3f2.x <= 0.0f) {
                    point3f2.x = 100.0f;
                }
                if (point3f2.y <= 0.0f) {
                    point3f2.y = 100.0f;
                }
                if (point3f2.z <= 0.0f) {
                    point3f2.z = 100.0f;
                }
                if (this.fileScaling.y == 0.0f) {
                    this.fileScaling.y = 1.0f;
                }
                if (this.fileScaling.z == 0.0f) {
                    this.fileScaling.z = 1.0f;
                }
                this.setFractionalCoordinates(true);
                this.latticeCells = new int[3];
                this.atomSetCollection.setLatticeCells(this.latticeCells, true, false);
                this.setUnitCell(point3f2.x * 2.0f / (point3f.x - ((Point3f)object).x), point3f2.y * 2.0f / (point3f.y - ((Point3f)object).y), point3f2.z * 2.0f / (point3f.z == ((Point3f)object).z ? 1.0f : point3f.z - ((Point3f)object).z), 90.0f, 90.0f, 90.0f);
                this.unitCellOffset = new Point3f(point3f2);
                this.unitCellOffset.scale(-1.0f);
                this.symmetry.toFractional(this.unitCellOffset, false);
                this.unitCellOffset.scaleAdd(-1.0f, (Tuple3f)object, this.unitCellOffset);
                this.symmetry.setUnitCellOffset(this.unitCellOffset);
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolDataScaling", new Point3f[]{object, point3f, point3f2});
            }
        }
        if (this.line.endsWith("#noautobond")) {
            this.line = this.line.substring(0, this.line.lastIndexOf(35)).trim();
            this.atomSetCollection.setNoAutoBond();
        }
        if ((n = this.line.indexOf("jmolscript:")) >= 0) {
            object = this.line.substring(n + 11, this.line.length());
            if (((String)object).indexOf("#") >= 0) {
                object = ((String)object).substring(0, ((String)object).indexOf("#"));
            }
            this.addJmolScript((String)object);
            this.line = this.line.substring(0, n).trim();
        }
    }

    protected void addJmolScript(String string) {
        Logger.info("#jmolScript: " + string);
        if (this.previousScript == null) {
            this.previousScript = "";
        } else if (!this.previousScript.endsWith(";")) {
            this.previousScript = this.previousScript + ";";
        }
        this.previousScript = this.previousScript + string;
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolscript", this.previousScript);
    }

    protected void addSiteScript(String string) {
        if (this.siteScript == null) {
            this.siteScript = "";
        } else if (!this.siteScript.endsWith(";")) {
            this.siteScript = this.siteScript + ";";
        }
        this.siteScript = this.siteScript + string;
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("sitescript", this.siteScript);
    }

    public String readLine() throws Exception {
        this.prevline = this.line;
        this.line = this.reader.readLine();
        if (this.os != null && this.line != null) {
            this.os.write(this.line.getBytes());
            this.os.write(10);
        }
        ++this.ptLine;
        if (Logger.debugging) {
            Logger.debug(this.line);
        }
        return this.line;
    }

    protected static final String[] getStrings(String string, int n, int n2) {
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            stringArray[n3] = string.substring(n4, n4 + n2);
            ++n3;
            n4 += n2;
        }
        return stringArray;
    }

    protected void parseStringInfestedFloatArray(String string, float[] fArray) {
        Parser.parseStringInfestedFloatArray(string, null, fArray);
    }

    protected String[] getTokens() {
        return Parser.getTokens(this.line);
    }

    protected static void getTokensFloat(String string, float[] fArray, int n) {
        Parser.parseFloatArray(AtomSetCollectionReader.getTokens(string), fArray, n);
    }

    public static String[] getTokens(String string) {
        return Parser.getTokens(string);
    }

    protected static String[] getTokens(String string, int n) {
        return Parser.getTokens(string, n);
    }

    protected float parseFloat() {
        return Parser.parseFloat(this.line, this.next);
    }

    public float parseFloat(String string) {
        this.next[0] = 0;
        return Parser.parseFloat(string, this.next);
    }

    protected float parseFloat(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseFloat(string, n2, this.next);
    }

    protected int parseInt() {
        return Parser.parseInt(this.line, this.next);
    }

    public int parseInt(String string) {
        this.next[0] = 0;
        return Parser.parseInt(string, this.next);
    }

    protected int parseInt(String string, int n) {
        this.next[0] = n;
        return Parser.parseInt(string, this.next);
    }

    protected int parseInt(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseInt(string, n2, this.next);
    }

    protected String parseToken() {
        return Parser.parseToken(this.line, this.next);
    }

    protected String parseToken(String string) {
        this.next[0] = 0;
        return Parser.parseToken(string, this.next);
    }

    protected String parseTokenNext(String string) {
        return Parser.parseToken(string, this.next);
    }

    protected String parseToken(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseToken(string, n2, this.next);
    }

    protected static String parseTrimmed(String string, int n) {
        return Parser.parseTrimmed(string, n);
    }

    protected static String parseTrimmed(String string, int n, int n2) {
        return Parser.parseTrimmed(string, n, n2);
    }
}

