/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

class ObjReader
extends PolygonFileReader {
    private int nPolygons;
    String pmeshError;
    Point3f pt = new Point3f();

    ObjReader(SurfaceGenerator surfaceGenerator, String string, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.jvxlFileHeaderBuffer.append("pmesh file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    void getSurfaceData() throws Exception {
        if (this.readPmesh()) {
            Logger.info("obj file contains " + this.nVertices + " vertices and " + this.nPolygons + " polygons for " + this.nTriangles + " triangles");
        } else {
            Logger.error(this.params.fileName + ": " + (this.pmeshError == null ? "Error reading obj data " : this.pmeshError));
        }
    }

    private boolean readPmesh() {
        block3: {
            this.nPolygons = 0;
            try {
                if (this.readVerticesAndPolygons()) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (this.pmeshError != null) break block3;
                this.pmeshError = "pmesh ERROR: " + exception;
            }
        }
        return false;
    }

    private boolean readVerticesAndPolygons() throws Exception {
        block20: {
            this.pmeshError = "pmesh ERROR: invalid vertex/face list";
            Point3f point3f = new Point3f();
            int n = 0;
            boolean bl = false;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            Integer n5 = null;
            String string = null;
            int[] nArray = new int[3];
            try {
                while (this.readLine() != null) {
                    if (this.line.length() < 2 || this.line.charAt(1) != ' ') continue;
                    switch (this.line.charAt(0)) {
                        case 'v': {
                            this.next[0] = 2;
                            point3f.set(Parser.parseFloat(this.line, this.next), Parser.parseFloat(this.line, this.next), Parser.parseFloat(this.line, this.next));
                            if (hashtable == null) {
                                n3 = this.nVertices;
                            } else {
                                string = "" + point3f;
                                n5 = (Integer)hashtable.get(string);
                                if (n5 == null) {
                                    n3 = this.nVertices;
                                    hashtable.put(string, n3);
                                } else {
                                    n3 = n5;
                                }
                            }
                            if (n3 == this.nVertices) {
                                if (this.isAnisotropic) {
                                    this.setVertexAnisotropy(point3f);
                                }
                                this.addVertexCopy(point3f, 0.0f, this.nVertices++);
                            }
                            nArray[n4 % 3] = n3;
                            ++n4;
                            break;
                        }
                        case 'f': {
                            int n6;
                            int n7;
                            int n8;
                            if (n4 == 3 && this.line.indexOf("//") < 0) {
                                hashtable = null;
                            }
                            ++this.nPolygons;
                            String[] stringArray = Parser.getTokens(this.line);
                            int n9 = stringArray.length - 1;
                            if (n9 == 4) {
                                hashtable = null;
                            }
                            if (hashtable == null) {
                                n8 = Parser.parseInt(stringArray[1]) - 1;
                                n7 = Parser.parseInt(stringArray[2]) - 1;
                                n6 = Parser.parseInt(stringArray[3]) - 1;
                                if (n9 == 4) {
                                    n2 = Parser.parseInt(stringArray[4]) - 1;
                                    this.addTriangleCheck(n8, n7, n6, 5, 0, false, n);
                                    this.nTriangles = this.addTriangleCheck(n7, n6, n2, 3, 0, false, n);
                                    break;
                                }
                            } else {
                                n8 = nArray[0];
                                n7 = nArray[1];
                                n6 = nArray[2];
                            }
                            this.nTriangles = this.addTriangleCheck(n8, n7, n6, 7, 0, false, n);
                            break;
                        }
                        case 'g': {
                            hashtable = null;
                            if (this.params.readAllData != bl) {
                                n = Graphics3D.getArgbFromString("[x" + this.line.substring(3) + "]");
                            }
                            bl = true;
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (this.line == null) break block20;
                this.pmeshError = "problem reading OBJ file at: " + this.line;
                return true;
            }
        }
        this.pmeshError = null;
        return true;
    }
}

