/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptFunction;
import org.jmol.util.Logger;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

public class ParallelProcessor
extends ScriptFunction {
    Viewer viewer;
    volatile Vector vShapeManagers = null;
    volatile int counter = 0;
    volatile Error error = null;
    Object lock = new Object();
    Vector processes = new Vector();

    ParallelProcessor(String string, int n) {
        super(string, n);
    }

    public static Object getExecutor() {
        return Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAllProcesses(Viewer viewer, boolean bl) {
        if (this.processes.size() == 0) {
            return;
        }
        this.viewer = viewer;
        boolean bl2 = bl && !viewer.isParallel() && viewer.setParallel(true);
        this.vShapeManagers = new Vector();
        this.error = null;
        this.counter = 0;
        if (Logger.debugging) {
            Logger.debug("running " + this.processes.size() + " processes on " + Viewer.nProcessors + " processesors");
        }
        this.counter = this.processes.size();
        int n = this.processes.size();
        while (--n >= 0) {
            this.runProcess((Process)this.processes.remove(0), bl2);
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.counter > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.error == null) continue;
                throw this.error;
            }
        }
        this.mergeResults();
        viewer.setParallel(false);
    }

    void mergeResults() {
        try {
            for (int i = 0; i < this.vShapeManagers.size(); ++i) {
                this.viewer.mergeShapes(((ShapeManager)this.vShapeManagers.get(i)).getShapes());
            }
        }
        catch (Error error) {
            throw error;
        }
        finally {
            this.counter = -1;
            this.vShapeManagers = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearShapeManager(Error error) {
        ParallelProcessor parallelProcessor = this;
        synchronized (parallelProcessor) {
            this.error = error;
            this.vShapeManagers = null;
            this.notifyAll();
        }
    }

    void addProcess(String string, ScriptContext scriptContext) {
        this.processes.add(new Process(string, scriptContext));
    }

    private void runProcess(Process process, boolean bl) {
        Executor executor;
        RunProcess runProcess = new RunProcess(process, this.lock, bl);
        Executor executor2 = executor = bl ? (Executor)this.viewer.getExecutor() : null;
        if (executor != null) {
            executor.execute(runProcess);
        } else {
            runProcess.run();
        }
    }

    class RunProcess
    implements Runnable {
        Process process;
        Object processLock;
        boolean inParallel;

        public RunProcess(Process process, Object object, boolean bl) {
            this.process = process;
            this.processLock = object;
            this.inParallel = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (ParallelProcessor.this.error == null) {
                    if (Logger.debugging) {
                        Logger.debug("Running process " + this.process.processName + " " + this.process.context.pc + " - " + (this.process.context.pcEnd - 1));
                    }
                    Object object = null;
                    if (this.inParallel) {
                        object = new ShapeManager(ParallelProcessor.this.viewer, ParallelProcessor.this.viewer.getModelSet());
                        ParallelProcessor.this.vShapeManagers.add(object);
                    }
                    ParallelProcessor.this.viewer.eval(this.process.context, (ShapeManager)object);
                    if (Logger.debugging) {
                        Logger.debug("Process " + this.process.processName + " complete");
                    }
                }
            }
            catch (Exception exception) {
                if (ParallelProcessor.this.tok != 364558) {
                    exception.printStackTrace();
                }
            }
            catch (Error error) {
                ParallelProcessor.this.clearShapeManager(error);
            }
            finally {
                Object object = this.processLock;
                synchronized (object) {
                    --ParallelProcessor.this.counter;
                    this.processLock.notifyAll();
                }
            }
        }
    }

    static class Process {
        String processName;
        ScriptContext context;

        Process(String string, ScriptContext scriptContext) {
            this.processName = string;
            this.context = scriptContext;
        }
    }
}

