/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolEdge;
import org.jmol.api.JmolMolecule;
import org.jmol.api.JmolNode;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAromatic;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMeasure;
import org.jmol.smiles.SmilesParser;
import org.jmol.util.Logger;

public class SmilesSearch
extends JmolMolecule {
    private static final int INITIAL_ATOMS = 16;
    SmilesAtom[] patternAtoms = new SmilesAtom[16];
    String pattern;
    JmolNode[] jmolAtoms;
    int jmolAtomCount;
    private BitSet bsSelected;
    BitSet bsRequired;
    boolean firstMatchOnly;
    boolean matchAllAtoms;
    boolean isSmarts;
    boolean isSmilesFind;
    SmilesSearch[] subSearches;
    boolean haveSelected;
    boolean haveBondStereochemistry;
    boolean haveAtomStereochemistry;
    boolean needRingData;
    boolean needAromatic;
    boolean needRingMemberships;
    int ringDataMax = Integer.MIN_VALUE;
    Vector measures = new Vector();
    boolean noAromatic;
    boolean ignoreStereochemistry;
    StringBuffer ringSets;
    BitSet bsAromatic = new BitSet();
    SmilesAtom lastChainAtom;
    boolean asVector;
    boolean getMaps;
    SmilesSearch parent = this;
    private boolean isSilent;
    private boolean isRingCheck;
    private int selectedAtomCount;
    private BitSet[] ringData;
    private int[] ringCounts;
    private int[] ringConnections;
    private BitSet bsFound = new BitSet();
    private Hashtable htNested;
    private int nNested;
    private SmilesBond nestedBond;
    private Vector vReturn;
    private BitSet bsReturn = new BitSet();
    VTemp v = new VTemp();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.pattern);
        stringBuffer.append("\nmolecular formula: " + this.getMolecularFormula(true));
        return stringBuffer.toString();
    }

    void setSelected(BitSet bitSet) {
        if (bitSet == null) {
            bitSet = new BitSet(this.jmolAtomCount);
            bitSet.set(0, this.jmolAtomCount);
        }
        this.bsSelected = bitSet;
    }

    void setAtomArray() {
        this.nodes = this.patternAtoms;
        if (this.patternAtoms.length > this.atomCount) {
            SmilesAtom[] smilesAtomArray = new SmilesAtom[this.atomCount];
            System.arraycopy(this.patternAtoms, 0, smilesAtomArray, 0, this.atomCount);
            this.patternAtoms = smilesAtomArray;
            this.nodes = smilesAtomArray;
        }
    }

    SmilesAtom addAtom() {
        SmilesAtom[] smilesAtomArray;
        if (this.atomCount >= this.patternAtoms.length) {
            smilesAtomArray = new SmilesAtom[this.patternAtoms.length * 2];
            System.arraycopy(this.patternAtoms, 0, smilesAtomArray, 0, this.patternAtoms.length);
            this.patternAtoms = smilesAtomArray;
        }
        this.patternAtoms[this.atomCount] = smilesAtomArray = new SmilesAtom(this.atomCount);
        ++this.atomCount;
        return smilesAtomArray;
    }

    int addNested(String string) {
        if (this.parent.htNested == null) {
            this.parent.htNested = new Hashtable();
        }
        this.setNested(++this.parent.nNested, string);
        return this.parent.nNested;
    }

    void setNested(int n, Object object) {
        this.parent.htNested.put("_" + n, object);
    }

    Object getNested(int n) {
        return this.parent.htNested.get("_" + n);
    }

    int getMissingHydrogenCount() {
        int n = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            int n2 = this.patternAtoms[i].missingHydrogenCount;
            if (n2 < 0) continue;
            n += n2;
        }
        return n;
    }

    void setRingData(BitSet bitSet) throws InvalidSmilesException {
        Object object;
        Object object2;
        int n;
        this.needAromatic &= bitSet == null & !this.noAromatic;
        if (!this.needAromatic) {
            this.bsAromatic.clear();
            if (bitSet != null) {
                this.bsAromatic.or(bitSet);
            }
            if (!this.needRingMemberships && !this.needRingData) {
                return;
            }
        }
        if (this.ringDataMax < 0) {
            this.ringDataMax = 8;
        }
        if (this.needRingData) {
            this.ringCounts = new int[this.jmolAtomCount];
            this.ringConnections = new int[this.jmolAtomCount];
            this.ringData = new BitSet[this.ringDataMax + 1];
        }
        this.ringSets = new StringBuffer();
        String string = "****";
        while (string.length() < this.ringDataMax) {
            string = string + string;
        }
        for (n = 3; n <= this.ringDataMax; ++n) {
            int n2;
            BitSet bitSet2;
            int n3;
            if (n > this.jmolAtomCount) continue;
            object2 = "*1" + string.substring(0, n - 2) + "*1";
            object = SmilesParser.getMolecule((String)object2, true);
            Vector vector = (Vector)this.getBitSets((SmilesSearch)object, false, true);
            if (this.needAromatic) {
                n3 = vector.size();
                while (--n3 >= 0) {
                    bitSet2 = (BitSet)vector.get(n3);
                    if (!SmilesAromatic.isFlatSp2Ring(this.jmolAtoms, this.bsSelected, bitSet2, 0.01f)) continue;
                    n2 = bitSet2.nextSetBit(0);
                    while (n2 >= 0) {
                        this.bsAromatic.set(n2);
                        n2 = bitSet2.nextSetBit(n2 + 1);
                    }
                }
            }
            if (!this.needRingData) continue;
            this.ringData[n] = new BitSet();
            for (n3 = 0; n3 < vector.size(); ++n3) {
                bitSet2 = (BitSet)vector.get(n3);
                this.ringData[n].or(bitSet2);
                n2 = bitSet2.nextSetBit(0);
                while (n2 >= 0) {
                    int n4 = n2;
                    this.ringCounts[n4] = this.ringCounts[n4] + 1;
                    n2 = bitSet2.nextSetBit(n2 + 1);
                }
            }
        }
        if (this.needRingData) {
            n = this.bsSelected.nextSetBit(0);
            while (n >= 0) {
                object2 = this.jmolAtoms[n];
                object = object2.getEdges();
                if (object != null) {
                    int n5 = ((JmolEdge[])object).length;
                    while (--n5 >= 0) {
                        if (this.ringCounts[object2.getBondedAtomIndex(n5)] <= 0) continue;
                        int n6 = n;
                        this.ringConnections[n6] = this.ringConnections[n6] + 1;
                    }
                }
                n = this.bsSelected.nextSetBit(n + 1);
            }
        }
    }

    private Object getBitSets(SmilesSearch smilesSearch, boolean bl, boolean bl2) throws InvalidSmilesException {
        smilesSearch.ringSets = this.ringSets;
        smilesSearch.jmolAtoms = this.jmolAtoms;
        smilesSearch.jmolAtomCount = this.jmolAtomCount;
        smilesSearch.bsSelected = this.bsSelected;
        smilesSearch.htNested = this.htNested;
        smilesSearch.isSmilesFind = this.isSmilesFind;
        smilesSearch.isSmarts = true;
        smilesSearch.bsAromatic = this.bsAromatic;
        smilesSearch.ringData = this.ringData;
        smilesSearch.ringCounts = this.ringCounts;
        smilesSearch.ringConnections = this.ringConnections;
        if (bl) {
            smilesSearch.bsRequired = null;
            smilesSearch.firstMatchOnly = false;
            smilesSearch.matchAllAtoms = false;
            smilesSearch.bsFound = this.bsFound;
        } else if (bl2) {
            smilesSearch.bsRequired = null;
            smilesSearch.isSilent = true;
            smilesSearch.isRingCheck = true;
            smilesSearch.asVector = true;
            smilesSearch.matchAllAtoms = false;
        } else {
            smilesSearch.haveSelected = this.haveSelected;
            smilesSearch.bsRequired = this.bsRequired;
            smilesSearch.firstMatchOnly = this.firstMatchOnly;
            smilesSearch.matchAllAtoms = this.matchAllAtoms;
            smilesSearch.getMaps = this.getMaps;
            smilesSearch.asVector = this.asVector;
            smilesSearch.vReturn = this.vReturn;
            smilesSearch.bsReturn = this.bsReturn;
        }
        return smilesSearch.search(bl);
    }

    Object search(boolean bl) throws InvalidSmilesException {
        if (Logger.debugging && !this.isSilent) {
            Logger.debug("SmilesSearch processing " + this.pattern);
        }
        if (this.vReturn == null && (this.asVector || this.getMaps)) {
            this.vReturn = new Vector();
        }
        if (this.bsSelected == null) {
            this.bsSelected = new BitSet(this.jmolAtomCount);
            this.bsSelected.set(0, this.jmolAtomCount);
        }
        this.selectedAtomCount = this.bsSelected.cardinality();
        if (this.subSearches != null) {
            for (int i = 0; i < this.subSearches.length; ++i) {
                if (this.subSearches[i] == null) continue;
                this.getBitSets(this.subSearches[i], false, false);
                if (!this.firstMatchOnly || !(this.vReturn == null ? this.bsReturn.nextSetBit(0) >= 0 : this.vReturn.size() > 0)) {
                    continue;
                }
                break;
            }
        } else if (this.atomCount > 0) {
            this.checkMatch(null, -1, -1, bl);
        }
        return this.asVector || this.getMaps ? this.vReturn : this.bsReturn;
    }

    private final boolean checkMatch(SmilesAtom smilesAtom, int n, int n2, boolean bl) throws InvalidSmilesException {
        if (smilesAtom == null) {
            if (this.nestedBond == null) {
                this.bsFound.clear();
            } else {
                this.bsReturn.clear();
            }
        } else {
            int n3;
            if (this.bsFound.get(n2) || !this.bsSelected.get(n2)) {
                return true;
            }
            JmolNode jmolNode = this.jmolAtoms[n2];
            if (smilesAtom.atomsOr != null) {
                for (int i = 0; i < smilesAtom.nAtomsOr; ++i) {
                    if (this.checkMatch(smilesAtom.atomsOr[i], n, n2, bl)) continue;
                    return false;
                }
                return true;
            }
            if (smilesAtom.primitives == null) {
                if (!this.checkPrimitiveAtom(smilesAtom, n2)) {
                    return true;
                }
            } else {
                for (n3 = 0; n3 < smilesAtom.nPrimitives; ++n3) {
                    if (this.checkPrimitiveAtom(smilesAtom.primitives[n3], n2)) continue;
                    return true;
                }
            }
            JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
            n3 = smilesAtom.getBondCount();
            block5: while (--n3 >= 0) {
                int n4;
                SmilesBond smilesBond = smilesAtom.getBond(n3);
                if (smilesBond.getAtomIndex2() != smilesAtom.index) continue;
                SmilesAtom smilesAtom2 = smilesBond.getAtom1();
                int n5 = smilesAtom2.getMatchingAtom();
                switch (smilesBond.bondType) {
                    case 96: 
                    case 112: {
                        if (this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond, n2, n5, null)) continue block5;
                        return true;
                    }
                }
                for (n4 = 0; n4 < jmolEdgeArray.length && (jmolEdgeArray[n4].getAtomIndex1() != n5 && jmolEdgeArray[n4].getAtomIndex2() != n5 || !jmolEdgeArray[n4].isCovalent()); ++n4) {
                }
                if (n4 == jmolEdgeArray.length) {
                    return true;
                }
                if (this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond, n2, n5, jmolEdgeArray[n4])) continue;
                return true;
            }
            this.patternAtoms[smilesAtom.index].setMatchingAtom(n2);
            if (Logger.debugging && !this.isSilent) {
                Logger.debug("pattern atom " + n + " " + smilesAtom);
            }
            this.bsFound.set(n2);
        }
        if (!this.continueMatch(n, n2, bl)) {
            return false;
        }
        if (n2 >= 0) {
            this.bsFound.clear(n2);
        }
        return true;
    }

    private boolean continueMatch(int n, int n2, boolean bl) throws InvalidSmilesException {
        int n3;
        int n4;
        if (++n < this.atomCount) {
            SmilesBond smilesBond;
            SmilesAtom smilesAtom = this.patternAtoms[n];
            SmilesBond smilesBond2 = n2 >= 0 ? smilesAtom.getBondTo(null) : (smilesBond = n == 0 ? this.nestedBond : null);
            if (smilesBond == null) {
                int n5;
                BitSet bitSet = (BitSet)this.bsFound.clone();
                if (smilesAtom.notBondedIndex >= 0) {
                    SmilesAtom smilesAtom2 = this.patternAtoms[smilesAtom.notBondedIndex];
                    JmolNode jmolNode = this.jmolAtoms[smilesAtom2.getMatchingAtom()];
                    if (smilesAtom2.bioType == '\u0000') {
                        JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
                        for (n5 = 0; n5 < jmolEdgeArray.length; ++n5) {
                            bitSet.set(jmolEdgeArray[n5].getOtherAtom(jmolNode).getIndex());
                        }
                    } else {
                        n5 = jmolNode.getOffsetResidueAtom("0", 1);
                        if (n5 >= 0) {
                            bitSet.set(n5);
                        }
                        if ((n5 = jmolNode.getOffsetResidueAtom("0", -1)) >= 0) {
                            bitSet.set(n5);
                        }
                    }
                }
                boolean bl2 = n2 >= 0 && smilesAtom.isBioAtom && (smilesAtom.atomName == null || smilesAtom.residueChar != null);
                int n6 = this.bsSelected.nextSetBit(0);
                while (n6 >= 0) {
                    if (!bitSet.get(n6) && !this.checkMatch(smilesAtom, n, n6, bl)) {
                        return false;
                    }
                    if (bl2 && (n5 = this.jmolAtoms[n6].getOffsetResidueAtom(smilesAtom.atomName, 1)) >= 0) {
                        n6 = n5 - 1;
                    }
                    n6 = this.bsSelected.nextSetBit(n6 + 1);
                }
                this.bsFound = bitSet;
                return true;
            }
            JmolNode jmolNode = this.jmolAtoms[smilesBond.getAtom1().getMatchingAtom()];
            switch (smilesBond.bondType) {
                case 96: {
                    int n7 = jmolNode.getOffsetResidueAtom(smilesAtom.atomName, 1);
                    if (n7 >= 0) {
                        BitSet bitSet = (BitSet)this.bsFound.clone();
                        jmolNode.setGroupBits(this.bsFound);
                        if (!this.checkMatch(smilesAtom, n, n7, bl)) {
                            return false;
                        }
                        this.bsFound = bitSet;
                    }
                    return true;
                }
                case 112: {
                    Vector vector = new Vector();
                    jmolNode.getCrossLinkLeadAtomIndexes(vector);
                    BitSet bitSet = (BitSet)this.bsFound.clone();
                    jmolNode.setGroupBits(this.bsFound);
                    for (int i = 0; i < vector.size(); ++i) {
                        if (this.checkMatch(smilesAtom, n, (Integer)vector.get(i), bl)) continue;
                        return false;
                    }
                    this.bsFound = bitSet;
                    return true;
                }
            }
            JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
            if (jmolEdgeArray != null) {
                for (int i = 0; i < jmolEdgeArray.length; ++i) {
                    if (this.checkMatch(smilesAtom, n, jmolNode.getBondedAtomIndex(i), bl)) continue;
                    return false;
                }
            }
            this.bsFound.clear(n2);
            return true;
        }
        if (!this.ignoreStereochemistry && !this.checkStereochemistry()) {
            return true;
        }
        BitSet bitSet = new BitSet();
        int n8 = 0;
        for (n4 = 0; n4 < this.atomCount; ++n4) {
            n3 = this.patternAtoms[n4].getMatchingAtom();
            if (!bl && this.haveSelected && !this.patternAtoms[n4].selected) continue;
            ++n8;
            bitSet.set(n3);
            if (this.patternAtoms[n4].isBioAtom && this.patternAtoms[n4].atomName == null) {
                this.jmolAtoms[n3].setGroupBits(bitSet);
            }
            if (bl) break;
            if (this.isSmarts || this.patternAtoms[n4].missingHydrogenCount <= 0) continue;
            this.getHydrogens(this.jmolAtoms[n3], bitSet);
        }
        if (this.bsRequired != null && !this.bsRequired.intersects(bitSet)) {
            return true;
        }
        if (this.matchAllAtoms && bitSet.cardinality() != this.selectedAtomCount) {
            return true;
        }
        this.bsReturn.or(bitSet);
        if (this.getMaps) {
            int[] nArray = new int[n8];
            int n9 = 0;
            for (n3 = 0; n3 < this.atomCount; ++n3) {
                if (!bl && this.haveSelected && !this.patternAtoms[n3].selected) continue;
                nArray[n9++] = this.patternAtoms[n3].getMatchingAtom();
            }
            this.vReturn.add(nArray);
            return !this.firstMatchOnly;
        }
        if (this.asVector) {
            n4 = 1;
            n3 = this.vReturn.size();
            while (--n3 >= 0 && n4 != 0) {
                n4 = !((BitSet)this.vReturn.get(n3)).equals(bitSet) ? 1 : 0;
            }
            if (n4 == 0) {
                return true;
            }
            this.vReturn.add(bitSet);
        }
        if (this.isRingCheck) {
            this.ringSets.append(" ");
            n4 = n * 3 + 2;
            while (--n4 > n) {
                this.ringSets.append("-").append(this.patternAtoms[(n4 <= n * 2 ? n * 2 - n4 + 1 : n4 - 1) % n].getMatchingAtom());
            }
            this.ringSets.append("- ");
            return true;
        }
        if (this.firstMatchOnly) {
            return false;
        }
        return bitSet.cardinality() != this.selectedAtomCount;
    }

    private JmolNode getHydrogens(JmolNode jmolNode, BitSet bitSet) {
        JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
        int n = -1;
        for (int i = 0; i < jmolEdgeArray.length; ++i) {
            if (this.jmolAtoms[jmolNode.getBondedAtomIndex(i)].getElementNumber() != 1) continue;
            n = jmolNode.getBondedAtomIndex(i);
            if (bitSet == null) break;
            bitSet.set(n);
        }
        return n >= 0 ? this.jmolAtoms[n] : null;
    }

    private boolean checkPrimitiveAtom(SmilesAtom smilesAtom, int n) throws InvalidSmilesException {
        boolean bl;
        block14: {
            block17: {
                int n2;
                JmolNode jmolNode;
                block19: {
                    int n3;
                    block18: {
                        block15: {
                            block16: {
                                block13: {
                                    jmolNode = this.jmolAtoms[n];
                                    bl = smilesAtom.not;
                                    if (smilesAtom.iNested <= 0) break block13;
                                    Object object = this.getNested(smilesAtom.iNested);
                                    if (object instanceof SmilesSearch) {
                                        SmilesSearch smilesSearch = (SmilesSearch)object;
                                        if (smilesAtom.isBioAtom) {
                                            smilesSearch.nestedBond = smilesAtom.getBondTo(null);
                                        }
                                        if ((object = this.getBitSets(smilesSearch, true, false)) == null) {
                                            object = new BitSet();
                                        }
                                        if (!smilesAtom.isBioAtom) {
                                            this.setNested(smilesAtom.iNested, object);
                                        }
                                    }
                                    bl = smilesAtom.not != ((BitSet)object).get(n);
                                    break block14;
                                }
                                if (!smilesAtom.isBioAtom) break block15;
                                if (smilesAtom.atomName != null && (!smilesAtom.isLeadAtom() ? !smilesAtom.atomName.equals(jmolNode.getAtomName().toUpperCase()) : !jmolNode.isLeadAtom())) break block14;
                                if (smilesAtom.residueName != null && !smilesAtom.residueName.equals(jmolNode.getGroup3(false).toUpperCase())) break block14;
                                if (smilesAtom.residueChar == null) break block16;
                                if (smilesAtom.isDna() && !jmolNode.isDna() || smilesAtom.isRna() && !jmolNode.isRna() || smilesAtom.isProtein() && !jmolNode.isProtein() || smilesAtom.isNucleic() && !jmolNode.isNucleic()) break block14;
                                String string = jmolNode.getGroup1('\u0000').toUpperCase();
                                boolean bl2 = smilesAtom.residueChar.equals(string);
                                switch (smilesAtom.residueChar.charAt(0)) {
                                    case 'N': {
                                        bl2 = smilesAtom.isNucleic() ? jmolNode.isNucleic() : bl2;
                                        break;
                                    }
                                    case 'R': {
                                        bl2 = smilesAtom.isNucleic() ? jmolNode.isPurine() : bl2;
                                        break;
                                    }
                                    case 'Y': {
                                        boolean bl3 = bl2 = smilesAtom.isNucleic() ? jmolNode.isPyrimidine() : bl2;
                                    }
                                }
                                if (!bl2) break block14;
                            }
                            if ((smilesAtom.elementNumber < 0 || smilesAtom.elementNumber == jmolNode.getElementNumber()) && (!smilesAtom.notCrossLinked || !jmolNode.getCrossLinkLeadAtomIndexes(null))) break block17;
                            break block14;
                        }
                        if (smilesAtom.jmolIndex >= 0 && jmolNode.getIndex() != smilesAtom.jmolIndex || smilesAtom.elementNumber >= 0 && smilesAtom.elementNumber != jmolNode.getElementNumber()) break block14;
                        boolean bl4 = smilesAtom.isAromatic();
                        if (!this.noAromatic && smilesAtom.elementNumber != -2 && bl4 != this.bsAromatic.get(n)) break block14;
                        n2 = smilesAtom.getAtomicMass();
                        if (n2 == Short.MIN_VALUE) break block18;
                        n3 = jmolNode.getIsotopeNumber();
                        if (n2 >= 0 && n2 != n3 || n2 < 0 && n3 != 0 && -n2 != n3) break block14;
                    }
                    if (smilesAtom.getCharge() != jmolNode.getFormalCharge() || (n2 = smilesAtom.getCovalentHydrogenCount() + smilesAtom.missingHydrogenCount) >= 0 && n2 != jmolNode.getCovalentHydrogenCount()) break block14;
                    n2 = smilesAtom.implicitHydrogenCount;
                    if (n2 == Integer.MIN_VALUE) break block19;
                    n3 = jmolNode.getImplicitHydrogenCount();
                    if (n2 != -1 ? n2 != n3 : n3 == 0) break block14;
                }
                if (smilesAtom.degree > 0 && smilesAtom.degree != jmolNode.getCovalentBondCount() || smilesAtom.nonhydrogenDegree > 0 && smilesAtom.nonhydrogenDegree != jmolNode.getCovalentBondCount() - jmolNode.getCovalentHydrogenCount() || smilesAtom.valence > 0 && smilesAtom.valence != jmolNode.getValence() || smilesAtom.connectivity > 0 && smilesAtom.connectivity != jmolNode.getCovalentBondCount() + jmolNode.getImplicitHydrogenCount() || this.ringData != null && smilesAtom.ringSize >= -1 && (smilesAtom.ringSize > 0 ? this.ringData[smilesAtom.ringSize] == null || !this.ringData[smilesAtom.ringSize].get(n) : this.ringCounts[n] == 0 != (smilesAtom.ringSize == 0))) break block14;
                if (this.ringData != null && smilesAtom.ringMembership >= -1 && (smilesAtom.ringMembership != -1 ? this.ringCounts[n] != smilesAtom.ringMembership : this.ringCounts[n] == 0)) break block14;
                if (smilesAtom.ringConnectivity < 0) break block17;
                n2 = this.ringConnections[n];
                if (smilesAtom.ringConnectivity == -1 && n2 == 0 || smilesAtom.ringConnectivity != -1 && n2 != smilesAtom.ringConnectivity) break block14;
            }
            bl = !bl;
        }
        return bl;
    }

    private boolean checkMatchBond(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, SmilesBond smilesBond, int n, int n2, JmolEdge jmolEdge) {
        if (smilesBond.bondsOr != null) {
            for (int i = 0; i < smilesBond.nBondsOr; ++i) {
                if (!this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond.bondsOr[i], n, n2, jmolEdge)) continue;
                return true;
            }
            return false;
        }
        if (smilesBond.primitives == null) {
            if (!this.checkPrimitiveBond(smilesAtom, smilesAtom2, smilesBond, n, n2, jmolEdge)) {
                return false;
            }
        } else {
            for (int i = 0; i < smilesBond.nPrimitives; ++i) {
                if (this.checkPrimitiveBond(smilesAtom, smilesAtom2, smilesBond.primitives[i], n, n2, jmolEdge)) continue;
                return false;
            }
        }
        smilesBond.matchingBond = jmolEdge;
        return true;
    }

    private boolean checkPrimitiveBond(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, SmilesBond smilesBond, int n, int n2, JmolEdge jmolEdge) {
        boolean bl = false;
        switch (smilesBond.bondType) {
            case 96: {
                return smilesBond.isNot != (this.jmolAtoms[n2].getOffsetResidueAtom("0", 1) == this.jmolAtoms[n].getOffsetResidueAtom("0", 0));
            }
            case 112: {
                return smilesBond.isNot != this.jmolAtoms[n].isCrossLinked(this.jmolAtoms[n2]);
            }
        }
        boolean bl2 = !this.noAromatic && smilesAtom.isAromatic();
        int n3 = jmolEdge.getCovalentOrder();
        if (bl2 && smilesAtom2.isAromatic()) {
            switch (smilesBond.bondType) {
                case 2: 
                case 17: 
                case 65: {
                    bl = SmilesSearch.isRingBond(this.ringSets, n, n2);
                    break;
                }
                case 1: {
                    bl = !this.isSmarts || !SmilesSearch.isRingBond(this.ringSets, n, n2);
                    break;
                }
                case -1: 
                case 81: 
                case 769: 
                case 1025: {
                    bl = true;
                }
            }
        } else {
            switch (smilesBond.bondType) {
                case -1: 
                case 81: {
                    bl = true;
                    break;
                }
                case 1: 
                case 257: 
                case 513: {
                    bl = n3 == 1 || n3 == 1041 || n3 == 1025;
                    break;
                }
                case 769: {
                    bl = n3 == (this.isSmilesFind ? 33 : 1);
                    break;
                }
                case 1025: {
                    bl = n3 == (this.isSmilesFind ? 97 : 1);
                    break;
                }
                case 2: {
                    bl = n3 == 2;
                    break;
                }
                case 3: {
                    bl = n3 == 3;
                    break;
                }
                case 65: {
                    bl = SmilesSearch.isRingBond(this.ringSets, n, n2);
                }
            }
        }
        return bl != smilesBond.isNot;
    }

    static boolean isRingBond(StringBuffer stringBuffer, int n, int n2) {
        return stringBuffer != null && stringBuffer.indexOf("-" + n + "-" + n2 + "-") >= 0;
    }

    private boolean checkStereochemistry() {
        Object object;
        int n;
        JmolNode jmolNode;
        JmolNode jmolNode2;
        JmolNode jmolNode3;
        JmolNode jmolNode4;
        int n2;
        for (n2 = 0; n2 < this.measures.size(); ++n2) {
            if (((SmilesMeasure)this.measures.get(n2)).check()) continue;
            return false;
        }
        if (this.haveAtomStereochemistry) {
            if (Logger.debugging) {
                Logger.debug("checking stereochemistry...");
            }
            JmolNode jmolNode5 = null;
            jmolNode4 = null;
            jmolNode3 = null;
            jmolNode2 = null;
            jmolNode = null;
            JmolNode jmolNode6 = null;
            SmilesAtom smilesAtom = null;
            SmilesAtom smilesAtom2 = null;
            block16: for (n = 0; n < this.atomCount; ++n) {
                int n3;
                SmilesAtom smilesAtom3 = this.patternAtoms[n];
                JmolNode jmolNode7 = this.jmolAtoms[smilesAtom3.getMatchingAtom()];
                int n4 = smilesAtom3.missingHydrogenCount;
                if (n4 < 0) {
                    n4 = 0;
                }
                if ((n3 = smilesAtom3.getChiralClass()) == Integer.MIN_VALUE) continue;
                int n5 = smilesAtom3.getChiralOrder();
                if (this.isSmilesFind && jmolNode7.getAtomSite() >> 8 != n3) {
                    return false;
                }
                jmolNode2 = null;
                if (Logger.debugging) {
                    Logger.debug("...type " + n3);
                }
                switch (n3) {
                    case 2: {
                        int n6;
                        boolean bl = true;
                        if (bl) {
                            smilesAtom = smilesAtom3.getBond(0).getOtherAtom(smilesAtom3);
                            smilesAtom2 = smilesAtom3.getBond(1).getOtherAtom(smilesAtom3);
                            if (smilesAtom == null || smilesAtom2 == null) continue block16;
                            SmilesAtom smilesAtom4 = smilesAtom3;
                            SmilesAtom smilesAtom5 = smilesAtom3;
                            while (smilesAtom.getBondCount() == 2 && smilesAtom2.getBondCount() == 2 && smilesAtom.getValence() == 4 && smilesAtom2.getValence() == 4) {
                                SmilesBond smilesBond = smilesAtom.getBondNotTo(smilesAtom4, true);
                                smilesAtom4 = smilesAtom;
                                smilesAtom = smilesBond.getOtherAtom(smilesAtom);
                                smilesBond = smilesAtom2.getBondNotTo(smilesAtom5, true);
                                smilesAtom5 = smilesAtom2;
                                smilesAtom2 = smilesBond.getOtherAtom(smilesAtom2);
                            }
                            smilesAtom3 = smilesAtom;
                        }
                        object = new JmolNode[6];
                        object[4] = new SmilesAtom(604);
                        int n7 = smilesAtom3.getBondCount();
                        for (n6 = 0; n6 < n7; ++n6) {
                            smilesAtom = smilesAtom3.bonds[n6].getOtherAtom(smilesAtom3);
                            if (smilesAtom3.bonds[n6].matchingBond.getCovalentOrder() == 2) {
                                if (smilesAtom2 != null) continue;
                                smilesAtom2 = smilesAtom;
                                continue;
                            }
                            if (object[0] == null) {
                                object[0] = this.getJmolAtom(smilesAtom.getMatchingAtom());
                                continue;
                            }
                            object[1] = this.getJmolAtom(smilesAtom.getMatchingAtom());
                        }
                        if (smilesAtom2 == null || (n7 = smilesAtom2.getBondCount()) < 2 || n7 > 3) continue block16;
                        for (n6 = 0; n6 < n7; ++n6) {
                            smilesAtom = smilesAtom2.bonds[n6].getOtherAtom(smilesAtom2);
                            if (smilesAtom2.bonds[n6].matchingBond.getCovalentOrder() == 2) continue;
                            if (object[2] == null) {
                                object[2] = this.getJmolAtom(smilesAtom.getMatchingAtom());
                                continue;
                            }
                            object[3] = this.getJmolAtom(smilesAtom.getMatchingAtom());
                        }
                        if (this.isSmilesFind) {
                            if (object[1] == null) {
                                this.getX(smilesAtom3, smilesAtom2, (JmolNode[])object, 1, false, bl);
                            }
                            if (object[3] == null) {
                                this.getX(smilesAtom2, smilesAtom3, (JmolNode[])object, 3, false, false);
                            }
                            if (!this.setSmilesCoordinates(jmolNode7, smilesAtom3, smilesAtom2, (JmolNode[])object)) {
                                return false;
                            }
                        }
                        if (object[1] == null) {
                            this.getX(smilesAtom3, smilesAtom2, (JmolNode[])object, 1, true, false);
                        }
                        if (object[3] == null) {
                            this.getX(smilesAtom2, smilesAtom3, (JmolNode[])object, 3, true, false);
                        }
                        if (SmilesSearch.checkStereochemistry(smilesAtom3.not, jmolNode7, n3, n5, object[0], object[1], object[2], object[3], null, null, this.v)) continue block16;
                        return false;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        jmolNode5 = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(0));
                        switch (n4) {
                            case 0: {
                                jmolNode4 = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(1));
                                break;
                            }
                            case 1: {
                                jmolNode4 = this.getHydrogens(this.getJmolAtom(smilesAtom3.getMatchingAtom()), null);
                                if (!smilesAtom3.isFirst) break;
                                JmolNode jmolNode8 = jmolNode4;
                                jmolNode4 = jmolNode5;
                                jmolNode5 = jmolNode8;
                                break;
                            }
                            default: {
                                continue block16;
                            }
                        }
                        jmolNode3 = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(2 - n4));
                        jmolNode2 = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(3 - n4));
                        jmolNode = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(4 - n4));
                        jmolNode6 = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(5 - n4));
                        if (this.isSmilesFind && !this.setSmilesCoordinates(jmolNode7, smilesAtom3, smilesAtom2, new JmolNode[]{jmolNode5, jmolNode4, jmolNode3, jmolNode2, jmolNode, jmolNode6})) {
                            return false;
                        }
                        if (SmilesSearch.checkStereochemistry(smilesAtom3.not, jmolNode7, n3, n5, jmolNode5, jmolNode4, jmolNode3, jmolNode2, jmolNode, jmolNode6, this.v)) continue block16;
                        return false;
                    }
                }
            }
        }
        if (this.haveBondStereochemistry) {
            for (n2 = 0; n2 < this.atomCount; ++n2) {
                int n8;
                jmolNode4 = this.patternAtoms[n2];
                jmolNode3 = null;
                jmolNode2 = null;
                jmolNode = null;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                n = jmolNode4.getBondCount();
                boolean bl = false;
                block21: for (n8 = 0; n8 < n; ++n8) {
                    object = jmolNode4.getBond(n8);
                    boolean bl2 = object.getAtom2() == jmolNode4;
                    int n12 = object.bondType;
                    switch (n12) {
                        case 2: 
                        case 769: 
                        case 1025: {
                            if (bl2) continue block21;
                            jmolNode3 = object.getAtom2();
                            n11 = n12;
                            boolean bl3 = bl = n12 != 2;
                            if (!bl) continue block21;
                            n9 = object.isNot ? -1 : 1;
                            continue block21;
                        }
                        case 257: 
                        case 513: {
                            jmolNode2 = bl2 ? object.getAtom1() : object.getAtom2();
                            n9 = bl2 != (n12 == 257) ? 1 : -1;
                        }
                    }
                }
                if (bl) {
                    object = jmolNode4.getBondNotTo((SmilesAtom)jmolNode3, false);
                    if (object == null) {
                        return false;
                    }
                    jmolNode2 = object.getOtherAtom((SmilesAtom)jmolNode4);
                    object = jmolNode3.getBondNotTo((SmilesAtom)jmolNode4, false);
                    if (object == null) {
                        return false;
                    }
                    jmolNode = object.getOtherAtom((SmilesAtom)jmolNode3);
                } else {
                    if (jmolNode3 == null || n9 == 0) continue;
                    n = jmolNode3.getBondCount();
                    for (n8 = 0; n8 < n && n10 == 0; ++n8) {
                        object = jmolNode3.getBond(n8);
                        boolean bl4 = object.getAtom2() == jmolNode3;
                        int n13 = object.bondType;
                        switch (n13) {
                            case 257: 
                            case 513: {
                                jmolNode = bl4 ? object.getAtom1() : object.getAtom2();
                                n10 = bl4 != (n13 == 257) ? 1 : -1;
                            }
                        }
                    }
                    if (n10 == 0) continue;
                }
                if (this.isSmilesFind) {
                    this.setSmilesBondCoordinates((SmilesAtom)jmolNode4, (SmilesAtom)jmolNode3, n11);
                }
                JmolNode jmolNode9 = this.getJmolAtom(jmolNode4.getMatchingAtom());
                JmolNode jmolNode10 = this.getJmolAtom(jmolNode3.getMatchingAtom());
                JmolNode jmolNode11 = this.getJmolAtom(jmolNode2.getMatchingAtom());
                JmolNode jmolNode12 = this.getJmolAtom(jmolNode.getMatchingAtom());
                if (jmolNode11 == null || jmolNode12 == null) {
                    return false;
                }
                SmilesMeasure.setTorsionData((Point3f)((Object)jmolNode11), (Point3f)((Object)jmolNode9), (Point3f)((Object)jmolNode10), (Point3f)((Object)jmolNode12), this.v, bl);
                if (bl) {
                    n10 = n11 == 769 ? 1 : -1;
                    float f = this.v.vTemp1.dot(this.v.vTemp2);
                    if (!(f < 0.05f) && !(f > 0.95f) && !(this.v.vNorm1.dot(this.v.vNorm2) * (float)n9 * (float)n10 > 0.0f)) continue;
                    return false;
                }
                if (!(this.v.vTemp1.dot(this.v.vTemp2) * (float)n9 * (float)n10 < 0.0f)) continue;
                return false;
            }
        }
        return true;
    }

    private void getX(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, JmolNode[] jmolNodeArray, int n, boolean bl, boolean bl2) {
        Object object;
        boolean bl3;
        JmolNode jmolNode = this.getJmolAtom(smilesAtom.getMatchingAtom());
        boolean bl4 = bl3 = smilesAtom.isFirst || n == 3;
        if (bl) {
            int n2;
            if (this.isSmarts) {
                object = jmolNode.getEdges();
                for (n2 = 0; n2 < ((JmolEdge[])object).length; ++n2) {
                    JmolNode jmolNode2;
                    if (object[n2].getCovalentOrder() == 2 || (jmolNode2 = this.jmolAtoms[jmolNode.getBondedAtomIndex(n2)]) == jmolNodeArray[n - 1]) continue;
                    jmolNodeArray[n] = jmolNode2;
                    break;
                }
            }
            if (jmolNodeArray[n] == null) {
                object = new Vector3f();
                n2 = 0;
                for (int i = 0; i < 4; ++i) {
                    if (jmolNodeArray[i] == null) continue;
                    ++n2;
                    ((Tuple3f)object).sub((Point3f)((Object)jmolNodeArray[i]));
                }
                if (((Vector3f)object).length() == 0.0f) {
                    ((Tuple3f)object).set((Point3f)((Object)jmolNodeArray[4]));
                    bl3 = false;
                } else {
                    ((Tuple3f)object).scaleAdd(n2 + 1, (Point3f)((Object)this.getJmolAtom(smilesAtom.getMatchingAtom())), (Tuple3f)object);
                    bl3 = this.isSmilesFind || bl3;
                }
                jmolNodeArray[n] = new SmilesAtom(-1);
                ((Point3f)((Object)jmolNodeArray[n])).set((Tuple3f)object);
            }
        }
        if (jmolNodeArray[n] == null) {
            jmolNodeArray[n] = this.getHydrogens(jmolNode, null);
            if (bl2) {
                bl3 = true;
            }
        }
        if (jmolNodeArray[n] != null && bl3) {
            object = jmolNodeArray[n];
            jmolNodeArray[n] = jmolNodeArray[n - 1];
            jmolNodeArray[n - 1] = object;
        }
    }

    static boolean checkStereochemistry(boolean bl, JmolNode jmolNode, int n, int n2, JmolNode jmolNode2, JmolNode jmolNode3, JmolNode jmolNode4, JmolNode jmolNode5, JmolNode jmolNode6, JmolNode jmolNode7, VTemp vTemp) {
        switch (n) {
            default: {
                return bl == (SmilesSearch.getHandedness(jmolNode3, jmolNode4, jmolNode5, jmolNode2, vTemp) != n2);
            }
            case 5: {
                return bl == (!SmilesSearch.isDiaxial(jmolNode, jmolNode, jmolNode6, jmolNode2, vTemp, -0.95f) || SmilesSearch.getHandedness(jmolNode3, jmolNode4, jmolNode5, jmolNode2, vTemp) != n2);
            }
            case 6: {
                if (bl != !SmilesSearch.isDiaxial(jmolNode, jmolNode, jmolNode7, jmolNode2, vTemp, -0.95f)) {
                    return false;
                }
                SmilesSearch.getPlaneNormals(jmolNode3, jmolNode4, jmolNode5, jmolNode6, vTemp);
                if (bl != (vTemp.vNorm1.dot(vTemp.vNorm2) < 0.0f || vTemp.vNorm2.dot(vTemp.vNorm3) < 0.0f)) {
                    return false;
                }
                vTemp.vNorm2.set((Point3f)((Object)jmolNode));
                vTemp.vNorm2.sub((Point3f)((Object)jmolNode2));
                return bl == ((vTemp.vNorm1.dot(vTemp.vNorm2) < 0.0f ? 2 : 1) == n2);
            }
            case 8: 
        }
        SmilesSearch.getPlaneNormals(jmolNode2, jmolNode3, jmolNode4, jmolNode5, vTemp);
        return vTemp.vNorm1.dot(vTemp.vNorm2) < 0.0f ? bl == (n2 != 3) : (vTemp.vNorm2.dot(vTemp.vNorm3) < 0.0f ? bl == (n2 != 2) : bl == (n2 != 1));
    }

    private JmolNode getJmolAtom(int n) {
        return n < 0 || n >= this.jmolAtoms.length ? null : this.jmolAtoms[n];
    }

    private void setSmilesBondCoordinates(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, int n) {
        JmolNode jmolNode = this.jmolAtoms[smilesAtom.getMatchingAtom()];
        JmolNode jmolNode2 = this.jmolAtoms[smilesAtom2.getMatchingAtom()];
        jmolNode.set(-1.0f, 0.0f, 0.0f);
        jmolNode2.set(1.0f, 0.0f, 0.0f);
        if (n == 2) {
            JmolNode[] jmolNodeArray;
            int n2 = 0;
            int n3 = 0;
            JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
            int n4 = jmolEdgeArray.length;
            while (--n4 >= 0) {
                jmolNodeArray = jmolEdgeArray[n4];
                JmolNode jmolNode3 = jmolNodeArray.getOtherAtom(jmolNode);
                if (jmolNode3 == jmolNode2) continue;
                jmolNode3.set(-1.0f, n2++ == 0 ? -1.0f : 1.0f, 0.0f);
                int n5 = jmolNodeArray.getAtomIndex2() == jmolNode.getIndex() ? n2 : -n2;
                switch (jmolNodeArray.getOrder()) {
                    case 1025: {
                        n3 = n5;
                        break;
                    }
                    case 1041: {
                        n3 = -n5;
                    }
                }
            }
            n4 = 0;
            n2 = 0;
            jmolNodeArray = new JmolNode[2];
            jmolEdgeArray = jmolNode2.getEdges();
            int n6 = jmolEdgeArray.length;
            while (--n6 >= 0) {
                JmolEdge jmolEdge = jmolEdgeArray[n6];
                JmolNode jmolNode4 = jmolEdge.getOtherAtom(jmolNode2);
                if (jmolNode4 == jmolNode) continue;
                jmolNodeArray[n2] = jmolNode4;
                jmolNode4.set(1.0f, n2++ == 0 ? 1.0f : -1.0f, 0.0f);
                int n7 = jmolEdge.getAtomIndex2() == jmolNode2.getIndex() ? n2 : -n2;
                switch (jmolEdge.getOrder()) {
                    case 1025: {
                        n4 = n7;
                        break;
                    }
                    case 1041: {
                        n4 = -n7;
                    }
                }
            }
            if (n3 * n4 > 0 == (Math.abs(n3) % 2 == Math.abs(n4) % 2)) {
                float f = ((Point3f)((Object)jmolNodeArray[0])).y;
                ((Point3f)((Object)jmolNodeArray[0])).y = ((Point3f)((Object)jmolNodeArray[1])).y;
                ((Point3f)((Object)jmolNodeArray[1])).y = f;
            }
        } else {
            JmolNode jmolNode5;
            JmolEdge jmolEdge;
            JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
            int n8 = 0;
            int n9 = jmolEdgeArray.length;
            while (--n9 >= 0) {
                jmolEdge = jmolEdgeArray[n9];
                if (jmolEdge.getOtherAtom(jmolNode) != jmolNode2) continue;
                n8 = jmolEdge.getOrder() == 33 ? 1 : -1;
                break;
            }
            n9 = jmolEdgeArray.length;
            while (--n9 >= 0) {
                jmolEdge = jmolEdgeArray[n9];
                jmolNode5 = jmolEdge.getOtherAtom(jmolNode);
                if (jmolNode5 == jmolNode2) continue;
                jmolNode5.set(-1.0f, 1.0f, 0.0f);
            }
            jmolEdgeArray = jmolNode2.getEdges();
            n9 = jmolEdgeArray.length;
            while (--n9 >= 0) {
                jmolEdge = jmolEdgeArray[n9];
                jmolNode5 = jmolEdge.getOtherAtom(jmolNode2);
                if (jmolNode5 == jmolNode) continue;
                jmolNode5.set(1.0f, 1.0f, (float)(-n8) / 2.0f);
            }
        }
    }

    private boolean setSmilesCoordinates(JmolNode jmolNode, SmilesAtom smilesAtom, SmilesAtom smilesAtom2, JmolNode[] jmolNodeArray) {
        JmolNode jmolNode2;
        int n = jmolNode.getAtomSite();
        if (n == Integer.MIN_VALUE) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        jmolNode2 = n2 == 2 || n2 == 3 ? (jmolNode2 = this.jmolAtoms[smilesAtom2.getMatchingAtom()]) : null;
        jmolNode.set(0.0f, 0.0f, 0.0f);
        jmolNode = this.jmolAtoms[smilesAtom.getMatchingAtom()];
        jmolNode.set(0.0f, 0.0f, 0.0f);
        int[] nArray = this.getMappedAtoms(jmolNode, jmolNode2, jmolNodeArray);
        switch (n2) {
            case 2: 
            case 4: {
                if (n3 == 2) {
                    int n4 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n4;
                }
                jmolNodeArray[nArray[0]].set(0.0f, 0.0f, 1.0f);
                jmolNodeArray[nArray[1]].set(1.0f, 0.0f, -1.0f);
                jmolNodeArray[nArray[2]].set(0.0f, 1.0f, -1.0f);
                jmolNodeArray[nArray[3]].set(-1.0f, -1.0f, -1.0f);
                break;
            }
            case 8: {
                switch (n3) {
                    case 1: {
                        jmolNodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        jmolNodeArray[nArray[1]].set(0.0f, 1.0f, 0.0f);
                        jmolNodeArray[nArray[2]].set(-1.0f, 0.0f, 0.0f);
                        jmolNodeArray[nArray[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        jmolNodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        jmolNodeArray[nArray[1]].set(-1.0f, 0.0f, 0.0f);
                        jmolNodeArray[nArray[2]].set(0.0f, 1.0f, 0.0f);
                        jmolNodeArray[nArray[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 3: {
                        jmolNodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        jmolNodeArray[nArray[1]].set(0.0f, 1.0f, 0.0f);
                        jmolNodeArray[nArray[2]].set(0.0f, -1.0f, 0.0f);
                        jmolNodeArray[nArray[3]].set(-1.0f, 0.0f, 0.0f);
                    }
                }
                break;
            }
            case 5: 
            case 6: {
                int n5 = nArray.length;
                if (n3 == 2) {
                    int n6 = nArray[0];
                    nArray[0] = nArray[n5 - 1];
                    nArray[n5 - 1] = n6;
                }
                jmolNodeArray[nArray[0]].set(0.0f, 0.0f, 1.0f);
                jmolNodeArray[nArray[n5 - 1]].set(0.0f, 0.0f, -1.0f);
                jmolNodeArray[nArray[1]].set(1.0f, 0.0f, 0.0f);
                jmolNodeArray[nArray[2]].set(0.0f, 1.0f, 0.0f);
                jmolNodeArray[nArray[3]].set(-1.0f, 0.0f, 0.0f);
                if (n5 != 6) break;
                jmolNodeArray[nArray[4]].set(0.0f, -1.0f, 0.0f);
            }
        }
        return true;
    }

    int[] getMappedAtoms(JmolNode jmolNode, JmolNode jmolNode2, JmolNode[] jmolNodeArray) {
        int n;
        int n2;
        int[] nArray = new int[jmolNodeArray[4] == null ? 4 : (jmolNodeArray[5] == null ? 5 : 6)];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = jmolNodeArray[n2] == null ? 104 + n2 * 100 : jmolNodeArray[n2].getIndex();
        }
        JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
        JmolEdge[] jmolEdgeArray2 = jmolNode2 == null ? null : jmolNode2.getEdges();
        for (n = 0; n < nArray.length; ++n) {
            for (n2 = 0; n2 < jmolEdgeArray.length && jmolEdgeArray[n2].getOtherAtom(jmolNode) != jmolNodeArray[n]; ++n2) {
            }
            if (n2 < jmolEdgeArray.length) {
                nArray[n] = n2 * 10 + 100 + n;
                continue;
            }
            if (jmolNode2 == null) continue;
            for (n2 = 0; n2 < jmolEdgeArray2.length && jmolEdgeArray2[n2].getOtherAtom(jmolNode2) != jmolNodeArray[n]; ++n2) {
            }
            if (n2 >= jmolEdgeArray2.length) continue;
            nArray[n] = n2 * 10 + 300 + n;
        }
        Arrays.sort(nArray);
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = nArray[n] % 10;
        }
        return nArray;
    }

    static boolean isDiaxial(JmolNode jmolNode, JmolNode jmolNode2, JmolNode jmolNode3, JmolNode jmolNode4, VTemp vTemp, float f) {
        vTemp.vA.set((Point3f)((Object)jmolNode));
        vTemp.vB.set((Point3f)((Object)jmolNode2));
        vTemp.vA.sub((Point3f)((Object)jmolNode3));
        vTemp.vB.sub((Point3f)((Object)jmolNode4));
        return vTemp.vA.dot(vTemp.vB) < f;
    }

    private static int getHandedness(JmolNode jmolNode, JmolNode jmolNode2, JmolNode jmolNode3, JmolNode jmolNode4, VTemp vTemp) {
        float f = SmilesAromatic.getNormalThroughPoints(jmolNode, jmolNode2, jmolNode3, vTemp.vTemp, vTemp.vA, vTemp.vB);
        return SmilesSearch.distanceToPlane(vTemp.vTemp, f, (Point3f)((Object)jmolNode4)) > 0.0f ? 1 : 2;
    }

    private static void getPlaneNormals(JmolNode jmolNode, JmolNode jmolNode2, JmolNode jmolNode3, JmolNode jmolNode4, VTemp vTemp) {
        SmilesAromatic.getNormalThroughPoints(jmolNode, jmolNode2, jmolNode3, vTemp.vNorm1, vTemp.vTemp1, vTemp.vTemp2);
        SmilesAromatic.getNormalThroughPoints(jmolNode2, jmolNode3, jmolNode4, vTemp.vNorm2, vTemp.vTemp1, vTemp.vTemp2);
        SmilesAromatic.getNormalThroughPoints(jmolNode3, jmolNode4, jmolNode, vTemp.vNorm3, vTemp.vTemp1, vTemp.vTemp2);
    }

    static float distanceToPlane(Vector3f vector3f, float f, Point3f point3f) {
        return vector3f == null ? Float.NaN : (vector3f.x * point3f.x + vector3f.y * point3f.y + vector3f.z * point3f.z + f) / (float)Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
    }

    void createTopoMap(BitSet bitSet) {
        Object object;
        int n;
        JmolEdge[] jmolEdgeArray;
        int n2;
        if (bitSet == null) {
            bitSet = new BitSet();
        }
        int n3 = this.getMissingHydrogenCount();
        SmilesAtom[] smilesAtomArray = new SmilesAtom[this.atomCount + n3];
        this.jmolAtoms = smilesAtomArray;
        int n4 = 0;
        BitSet bitSet2 = new BitSet();
        for (n2 = 0; n2 < this.atomCount; ++n2) {
            jmolEdgeArray = this.patternAtoms[n2];
            n = jmolEdgeArray.getChiralClass();
            int n5 = jmolEdgeArray.missingHydrogenCount;
            if (n5 < 0) {
                n5 = 0;
            }
            SmilesAtom smilesAtom = smilesAtomArray[n4] = new SmilesAtom(0, n4, n == Integer.MIN_VALUE ? n : (n << 8) + jmolEdgeArray.getChiralOrder(), jmolEdgeArray.elementNumber, jmolEdgeArray.getCharge());
            smilesAtom.atomName = jmolEdgeArray.atomName;
            smilesAtom.residueName = jmolEdgeArray.residueName;
            smilesAtom.residueChar = jmolEdgeArray.residueChar;
            smilesAtom.isBioAtom = jmolEdgeArray.isBioAtom;
            smilesAtom.isLeadAtom = jmolEdgeArray.isLeadAtom;
            smilesAtom.setAtomicMass(jmolEdgeArray.getAtomicMass());
            if (jmolEdgeArray.isAromatic()) {
                bitSet.set(n4);
            }
            if (!jmolEdgeArray.isFirst && n5 == 1 && n > 0) {
                bitSet2.set(n4);
            }
            jmolEdgeArray.setMatchingAtom(n4++);
            SmilesBond[] smilesBondArray = new SmilesBond[jmolEdgeArray.getBondCount() + n5];
            smilesAtom.setBonds(smilesBondArray);
            while (--n5 >= 0) {
                smilesAtomArray[n4] = new SmilesAtom(0, n4, 0, 1, 0);
                object = smilesAtomArray[n4];
                ++n4;
                ((SmilesAtom)object).setBonds(new SmilesBond[1]);
                SmilesBond smilesBond = new SmilesBond(smilesAtom, (SmilesAtom)object, 1, false);
                Logger.info("" + smilesBond);
            }
        }
        for (n2 = 0; n2 < this.atomCount; ++n2) {
            jmolEdgeArray = this.patternAtoms[n2];
            n = jmolEdgeArray.getMatchingAtom();
            SmilesAtom smilesAtom = smilesAtomArray[n];
            int n6 = jmolEdgeArray.getBondCount();
            for (int i = 0; i < n6; ++i) {
                Object object2;
                boolean bl;
                object = jmolEdgeArray.getBond(i);
                boolean bl2 = bl = ((SmilesBond)object).getAtom1() == jmolEdgeArray;
                if (bl) {
                    int n7 = 1;
                    switch (((SmilesBond)object).bondType) {
                        case 769: {
                            n7 = 33;
                            break;
                        }
                        case 1025: {
                            n7 = 97;
                            break;
                        }
                        case 257: {
                            n7 = 1025;
                            break;
                        }
                        case 513: {
                            n7 = 1041;
                            break;
                        }
                        case 96: 
                        case 112: {
                            n7 = ((SmilesBond)object).bondType;
                            break;
                        }
                        case 1: {
                            n7 = 1;
                            break;
                        }
                        case 17: {
                            n7 = 514;
                            break;
                        }
                        case 2: {
                            n7 = 2;
                            break;
                        }
                        case 3: {
                            n7 = 3;
                        }
                    }
                    object2 = smilesAtomArray[((SmilesBond)object).getAtom2().getMatchingAtom()];
                    SmilesBond smilesBond = new SmilesBond(smilesAtom, (SmilesAtom)object2, n7, false);
                    --((SmilesAtom)object2).bondCount;
                    Logger.info("" + smilesBond);
                    continue;
                }
                SmilesAtom smilesAtom2 = smilesAtomArray[((SmilesBond)object).getAtom1().getMatchingAtom()];
                object2 = smilesAtom2.getBondTo(smilesAtom);
                smilesAtom.addBond((SmilesBond)object2);
            }
        }
        n2 = bitSet2.nextSetBit(0);
        while (n2 >= 0) {
            jmolEdgeArray = smilesAtomArray[n2].getEdges();
            JmolEdge jmolEdge = jmolEdgeArray[0];
            jmolEdgeArray[0] = jmolEdgeArray[1];
            jmolEdgeArray[1] = jmolEdge;
            n2 = bitSet2.nextSetBit(n2 + 1);
        }
    }

    public void setParent(SmilesSearch smilesSearch) {
        this.parent = smilesSearch == null ? this : smilesSearch.getParent();
    }

    SmilesSearch getParent() {
        return this.parent == this ? this : this.parent.getParent();
    }

    static class VTemp {
        final Vector3f vTemp = new Vector3f();
        final Vector3f vA = new Vector3f();
        final Vector3f vB = new Vector3f();
        final Vector3f vTemp1 = new Vector3f();
        final Vector3f vTemp2 = new Vector3f();
        final Vector3f vNorm1 = new Vector3f();
        final Vector3f vNorm2 = new Vector3f();
        final Vector3f vNorm3 = new Vector3f();

        VTemp() {
        }
    }
}

