/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Vector;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

class ScriptManager {
    Viewer viewer;
    Thread[] queueThreads = new Thread[2];
    boolean[] scriptQueueRunning = new boolean[2];
    Vector scriptQueue = new Vector();
    Thread commandWatcherThread;
    boolean useCommandWatcherThread = false;

    ScriptManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void clear() {
        this.startCommandWatcher(false);
    }

    public String addScript(String string) {
        return (String)this.addScript("string", string, "", false, false);
    }

    public String addScript(String string, boolean bl, boolean bl2) {
        return (String)this.addScript("String", string, "", bl, bl2);
    }

    public Object addScript(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (!this.viewer.usingScriptQueue()) {
            this.clearQueue();
            this.viewer.haltScriptExecution();
        }
        if (this.commandWatcherThread == null && this.useCommandWatcherThread) {
            this.startCommandWatcher(true);
        }
        if (this.commandWatcherThread != null && string2.indexOf("/*SPLIT*/") >= 0) {
            String[] stringArray = TextFormat.split(string2, "/*SPLIT*/");
            for (int i = 0; i < stringArray.length; ++i) {
                this.addScript(string, stringArray[i], string3, bl, bl2);
            }
            return "split into " + stringArray.length + " sections for processing";
        }
        boolean bl3 = this.commandWatcherThread != null && (string2.indexOf("javascript") < 0 || string2.indexOf("#javascript ") >= 0);
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(string2);
        vector.addElement(string3);
        vector.addElement(string);
        vector.addElement(bl ? Boolean.TRUE : Boolean.FALSE);
        vector.addElement(bl2 ? Boolean.TRUE : Boolean.FALSE);
        vector.addElement(new Integer(bl3 ? -1 : 1));
        this.scriptQueue.addElement(vector);
        this.startScriptQueue(false);
        return "pending";
    }

    public int getScriptCount() {
        return this.scriptQueue.size();
    }

    void clearQueue() {
        this.scriptQueue.clear();
    }

    public void waitForQueue() {
        int n = 0;
        while (this.queueThreads[0] != null || this.queueThreads[1] != null) {
            try {
                Thread.sleep(100L);
                if (n++ % 10 != 0 || !Logger.debugging) continue;
                Logger.info("...scriptManager waiting for queue: " + this.scriptQueue.size() + " thread=" + Thread.currentThread().getName());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void flushQueue(String string) {
        int n = this.scriptQueue.size();
        while (--n >= 0) {
            String string2 = (String)((Vector)this.scriptQueue.elementAt(n)).elementAt(0);
            if (string2.indexOf(string) != 0) continue;
            this.scriptQueue.removeElementAt(n);
            if (!Logger.debugging) continue;
            Logger.debug(this.scriptQueue.size() + " scripts; removed: " + string2);
        }
    }

    void startScriptQueue(boolean bl) {
        int n;
        int n2 = n = bl ? 1 : 0;
        if (this.scriptQueueRunning[n]) {
            return;
        }
        this.scriptQueueRunning[n] = true;
        this.queueThreads[n] = new Thread(new ScriptQueueRunnable(bl, n));
        this.queueThreads[n].setName("QueueThread" + n);
        this.queueThreads[n].start();
    }

    Vector getScriptItem(boolean bl, boolean bl2) {
        Vector vector = (Vector)this.scriptQueue.elementAt(0);
        int n = (Integer)vector.elementAt(5);
        boolean bl3 = bl ? n < 0 : (bl2 ? n == 0 : n == 1);
        return bl3 ? vector : null;
    }

    synchronized void startCommandWatcher(boolean bl) {
        this.useCommandWatcherThread = bl;
        if (bl) {
            if (this.commandWatcherThread != null) {
                return;
            }
            this.commandWatcherThread = new Thread(new CommandWatcher());
            this.commandWatcherThread.setName("CommmandWatcherThread");
            this.commandWatcherThread.start();
        } else {
            if (this.commandWatcherThread == null) {
                return;
            }
            this.commandWatcherThread.interrupt();
            this.commandWatcherThread = null;
        }
        if (Logger.debugging) {
            Logger.info("command watcher " + (bl ? "started" : "stopped") + this.commandWatcherThread);
        }
    }

    void interruptQueueThreads() {
        for (int i = 0; i < this.queueThreads.length; ++i) {
            if (this.queueThreads[i] == null) continue;
            this.queueThreads[i].interrupt();
        }
    }

    class CommandWatcher
    implements Runnable {
        CommandWatcher() {
        }

        public void run() {
            Thread.currentThread().setPriority(1);
            int n = 50;
            while (ScriptManager.this.commandWatcherThread != null) {
                try {
                    Vector vector;
                    Thread.sleep(n);
                    if (ScriptManager.this.commandWatcherThread == null || ScriptManager.this.scriptQueue.size() <= 0 || (vector = ScriptManager.this.getScriptItem(true, true)) == null) continue;
                    vector.setElementAt(new Integer(0), 5);
                    ScriptManager.this.startScriptQueue(true);
                }
                catch (InterruptedException interruptedException) {
                    Logger.warn("CommandWatcher InterruptedException! " + this);
                    break;
                }
                catch (Exception exception) {
                    String string = "script processing ERROR:\n\n" + exception.toString();
                    for (int i = 0; i < exception.getStackTrace().length; ++i) {
                        string = string + "\n" + exception.getStackTrace()[i].toString();
                    }
                    Logger.warn("CommandWatcher Exception! " + string);
                    break;
                }
            }
            ScriptManager.this.commandWatcherThread = null;
        }
    }

    class ScriptQueueRunnable
    implements Runnable {
        boolean startedByCommandThread = false;
        int pt;

        public ScriptQueueRunnable(boolean bl, int n) {
            this.startedByCommandThread = bl;
            this.pt = n;
        }

        public void run() {
            while (ScriptManager.this.scriptQueue.size() != 0) {
                if (this.runNextScript()) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    Logger.error(this + " Exception " + exception.getMessage());
                    break;
                }
            }
            ScriptManager.this.queueThreads[this.pt].interrupt();
            this.stop();
        }

        public void stop() {
            ScriptManager.this.scriptQueueRunning[this.pt] = false;
            ScriptManager.this.queueThreads[this.pt] = null;
            ScriptManager.this.viewer.setSyncDriver(4);
        }

        private boolean runNextScript() {
            if (ScriptManager.this.scriptQueue.size() == 0) {
                return false;
            }
            Vector vector = ScriptManager.this.getScriptItem(false, this.startedByCommandThread);
            if (vector == null) {
                return false;
            }
            String string = (String)vector.elementAt(0);
            String string2 = (String)vector.elementAt(1);
            String string3 = (String)vector.elementAt(2);
            boolean bl = (Boolean)vector.elementAt(3);
            boolean bl2 = (Boolean)vector.elementAt(4);
            if (Logger.debugging) {
                Logger.info("Queue[" + this.pt + "][" + ScriptManager.this.scriptQueue.size() + "] scripts; running: " + string);
            }
            ScriptManager.this.scriptQueue.removeElementAt(0);
            this.runScript(string3, string, string2, bl, bl2);
            return ScriptManager.this.scriptQueue.size() != 0;
        }

        private void runScript(String string, String string2, String string3, boolean bl, boolean bl2) {
            ScriptManager.this.viewer.evalStringWaitStatus(string, string2, string3, bl, bl2, true);
        }
    }
}

