/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer.binding;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public abstract class Binding {
    public static final int WHEEL = 32;
    public static final int LEFT = 16;
    public static final int MIDDLE = 8;
    public static final int ALT = 8;
    public static final int RIGHT = 4;
    public static final int CTRL = 2;
    public static final int SHIFT = 1;
    public static final int CTRL_ALT = 10;
    public static final int LEFT_MIDDLE_RIGHT = 28;
    public static final int DOUBLE_CLICK = 512;
    public static final int SINGLE_CLICK = 256;
    public static final int DOWN = 1024;
    public static final int MOVED = 0;
    public static final int DRAGGED = 1;
    public static final int CLICKED = 2;
    public static final int WHEELED = 3;
    public static final int PRESSED = 4;
    public static final int RELEASED = 5;
    private static final int BUTTON_MODIFIER_MASK = 63;
    private String name;
    private Hashtable bindings = new Hashtable();

    public Hashtable getBindings() {
        return this.bindings;
    }

    public Binding(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public final void bind(int n, int n2) {
        this.addBinding(n + "\t" + n2, new int[]{n, n2});
    }

    public void bind(int n, String string) {
        this.addBinding(n + "\t", Boolean.TRUE);
        this.addBinding(n + "\t" + string, new String[]{Binding.getMouseActionName(n, false), string});
    }

    public final void unbind(int n, int n2) {
        if (n == 0) {
            this.unbindJmolAction(n2);
        } else {
            this.removeBinding(n + "\t" + n2);
        }
    }

    public final void unbind(int n, String string) {
        if (string == null) {
            this.unbindMouseAction(n);
        } else {
            this.removeBinding(n + "\t" + string);
        }
    }

    public final void unbindJmolAction(int n) {
        Enumeration enumeration = this.bindings.keys();
        String string = "\t" + n;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.endsWith(string)) continue;
            this.removeBinding(string2);
        }
    }

    private void addBinding(String string, Object object) {
        if (Logger.debugging) {
            Logger.debug("adding binding " + string + "\t==\t" + Escape.escape(object));
        }
        this.bindings.put(string, object);
    }

    private void removeBinding(String string) {
        if (Logger.debugging) {
            Logger.debug("removing binding " + string);
        }
        this.bindings.remove(string);
    }

    public final void unbindUserAction(String string) {
        Enumeration enumeration = this.bindings.keys();
        String string2 = "\t" + string;
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.endsWith(string2)) continue;
            this.removeBinding(string3);
        }
    }

    public final void unbindMouseAction(int n) {
        Enumeration enumeration = this.bindings.keys();
        String string = n + "\t";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            this.removeBinding(string2);
        }
    }

    public final boolean isBound(int n, int n2) {
        return this.bindings.containsKey(n + "\t" + n2);
    }

    public final boolean isUserAction(int n) {
        return this.bindings.containsKey(n + "\t");
    }

    public static int getMouseAction(int n, int n2) {
        if (n > 2) {
            n = 2;
        }
        return n2 & 0x3F | (n == Integer.MIN_VALUE ? 1024 : n << 8);
    }

    public static int getMouseAction(String string) {
        boolean bl;
        if (string == null || string.length() < 3) {
            return 0;
        }
        int n = 0;
        if ((string = string.toUpperCase()).indexOf("MIDDLE") >= 0) {
            n |= 8;
        } else if (string.indexOf("RIGHT") >= 0) {
            n |= 4;
        } else if (string.indexOf("WHEEL") >= 0) {
            n |= 0x20;
        } else if (string.indexOf("LEFT") >= 0) {
            n |= 0x10;
        }
        boolean bl2 = bl = n == 0;
        if (string.indexOf("DOUBLE") >= 0) {
            n |= 0x200;
        } else if (n > 0 && (n & 0x20) == 0 || string.indexOf("SINGLE") >= 0) {
            n |= 0x100;
        } else if (string.indexOf("DOWN") >= 0) {
            n |= 0x400;
        }
        if (string.indexOf("CTRL") >= 0) {
            n |= 2;
        }
        if (string.indexOf("ALT") >= 0) {
            n |= 8;
        }
        if (string.indexOf("SHIFT") >= 0) {
            n |= 1;
        }
        if (bl && n != 0) {
            n |= 0x10;
        }
        return n;
    }

    public static int getModifiers(int n) {
        return n & 0x3F;
    }

    public static int getClickCount(int n) {
        return n >> 8;
    }

    public String getBindingInfo(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string == null || string.equalsIgnoreCase("all") ? null : string.toLowerCase();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            vectorArray[i] = string2 == null || stringArray[i].toLowerCase().indexOf(string2) >= 0 ? new Vector() : null;
        }
        Enumeration enumeration = this.bindings.keys();
        while (enumeration.hasMoreElements()) {
            int[] nArray;
            int n;
            Object v = this.bindings.get((String)enumeration.nextElement());
            if (!(v instanceof int[]) || vectorArray[n = (nArray = (int[])v)[1]] == null) continue;
            vectorArray[n].add(Binding.getMouseActionName(nArray[0], true));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            if (vectorArray[i] == null || (n = vectorArray[i].size()) == 0) continue;
            Object[] objectArray = vectorArray[i].toArray();
            Arrays.sort(objectArray);
            stringBuffer.append(stringArray[i]).append("\t");
            String string3 = "";
            for (int j = 0; j < n; ++j) {
                stringBuffer.append(string3);
                stringBuffer.append(((String)objectArray[j]).substring(7));
                string3 = ", ";
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private static boolean includes(int n, int n2) {
        return (n & n2) == n2;
    }

    public static String getMouseActionName(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            return "";
        }
        boolean bl2 = Binding.includes(n, 8) && !Binding.includes(n, 16) && !Binding.includes(n, 4);
        char[] cArray = "      ".toCharArray();
        if (Binding.includes(n, 2)) {
            stringBuffer.append("CTRL+");
            cArray[4] = 67;
        }
        if (!bl2 && Binding.includes(n, 8)) {
            stringBuffer.append("ALT+");
            cArray[3] = 65;
        }
        if (Binding.includes(n, 1)) {
            stringBuffer.append("SHIFT+");
            cArray[2] = 83;
        }
        if (Binding.includes(n, 16)) {
            cArray[1] = 76;
            stringBuffer.append("LEFT");
        } else if (Binding.includes(n, 4)) {
            cArray[1] = 82;
            stringBuffer.append("RIGHT");
        } else if (bl2) {
            cArray[1] = 87;
            stringBuffer.append("MIDDLE");
        } else if (Binding.includes(n, 32)) {
            cArray[1] = 87;
            stringBuffer.append("WHEEL");
        }
        if (Binding.includes(n, 512)) {
            stringBuffer.append("+double-click");
            cArray[0] = 50;
        } else if (Binding.includes(n, 1024)) {
            stringBuffer.append("+down");
            cArray[0] = 52;
        }
        return bl ? new String(cArray) + ":" + stringBuffer.toString() : stringBuffer.toString();
    }
}

